/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.flags;

import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class FlagParser {
    public ParsedFlags parse(String ... args) throws FlagParseException {
        ArrayList<String> commands = new ArrayList<String>();
        ArrayList<String> argsToProcess = new ArrayList<String>(Arrays.asList(args));
        while (argsToProcess.size() > 0 && !((String)argsToProcess.get(0)).startsWith("-")) {
            commands.add((String)argsToProcess.get(0));
            argsToProcess.remove(0);
        }
        return ParsedFlags.create(commands, this.parseFlags(argsToProcess));
    }

    private ImmutableMap<String, String> parseFlags(List<String> args) throws FlagParseException {
        HashMap<String, String> flagMap = new HashMap<String, String>();
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                throw new FlagParseException(String.format("Syntax error: flags should start with -- (%s)", arg));
            }
            String[] segments = arg.substring(2).split("=", 2);
            String value = "";
            if (segments.length == 2) {
                value = segments[1];
            }
            if (flagMap.putIfAbsent(segments[0], value) == null) continue;
            throw new FlagParseException(String.format("Flag %s has been set more than once.", segments[0]));
        }
        return ImmutableMap.copyOf(flagMap);
    }

    public static class FlagParseException
    extends IllegalStateException {
        public FlagParseException(String message) {
            super(message);
        }
    }
}

