/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.io.ZipPath;
import com.android.tools.build.bundletool.model.AbiName;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableSet;
import java.util.regex.Pattern;

public class BundleFilesValidator
extends SubValidator {
    private static final Pattern CLASSES_DEX_PATTERN = Pattern.compile("classes[0-9]*\\.dex");
    private static final ImmutableSet<ZipPath> RESERVED_ROOT_APK_ENTRIES = ImmutableSet.of((Object)BundleModule.LIB_DIRECTORY, (Object)BundleModule.RESOURCES_DIRECTORY, (Object)ZipPath.create("AndroidManifest.xml"), (Object)ZipPath.create("resources.arsc"), (Object)ZipPath.create("AndroidManifest.xml"), (Object)BundleModule.RESOURCES_PROTO_PATH, (Object[])new ZipPath[0]);

    @Override
    public void validateModuleFile(ZipPath file) {
        String fileName = file.getFileName().toString();
        if (!BundleModule.SPECIAL_FILES.contains((Object)file) && !file.startsWith(BundleModule.ASSETS_DIRECTORY)) {
            if (file.startsWith(BundleModule.DEX_DIRECTORY)) {
                if (!fileName.endsWith(".dex")) {
                    throw ValidationException.builder().withMessage("Files under %s/ must have .dex extension, found '%s'.", BundleModule.DEX_DIRECTORY, file).build();
                }
            } else if (file.startsWith(BundleModule.LIB_DIRECTORY)) {
                if (file.getNameCount() != 3) {
                    throw ValidationException.builder().withMessage("Native library files need to have paths in form '%s/<single-directory>/<file>.so' but found '%s'.", BundleModule.LIB_DIRECTORY, file).build();
                }
                if (!fileName.endsWith(".so")) {
                    throw ValidationException.builder().withMessage("Files under %s/ must have .so extension, found '%s'.", BundleModule.LIB_DIRECTORY, file).build();
                }
                String subDirName = file.getName(1).toString();
                if (!AbiName.fromPlatformName(subDirName).isPresent()) {
                    throw ValidationException.builder().withMessage("Unrecognized native architecture for directory '%s'.", file.subpath(0, 2)).build();
                }
            } else if (file.startsWith(BundleModule.MANIFEST_DIRECTORY)) {
                if (!fileName.equals("AndroidManifest.xml")) {
                    throw ValidationException.builder().withMessage("Only '%s' is accepted under directory '%s' but found file '%s'.", "AndroidManifest.xml", BundleModule.MANIFEST_DIRECTORY, file).build();
                }
            } else if (file.startsWith(BundleModule.RESOURCES_DIRECTORY)) {
                if (file.getNameCount() == 2) {
                    throw ValidationException.builder().withMessage("The %s/ directory cannot contain files directly, found '%s'.", BundleModule.RESOURCES_DIRECTORY, file).build();
                }
            } else if (file.startsWith(BundleModule.ROOT_DIRECTORY)) {
                ZipPath nameUnderRoot = file.getName(1);
                if (BundleFilesValidator.isReservedRootApkEntry(nameUnderRoot)) {
                    throw ValidationException.builder().withMessage("File '%s' uses reserved file or directory name '%s'.", file, nameUnderRoot).build();
                }
            } else {
                throw ValidationException.builder().withMessage("Module files can be only in pre-defined directories, but found '%s'.", file).build();
            }
        }
    }

    private static boolean isReservedRootApkEntry(ZipPath name) {
        return RESERVED_ROOT_APK_ENTRIES.contains((Object)name) || CLASSES_DEX_PATTERN.matcher(name.toString()).matches();
    }
}

