/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.dexsplitter;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import shadow.bundletool.com.android.tools.r8.CompilationException;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.D8Command;
import shadow.bundletool.com.android.tools.r8.DexIndexedConsumer;
import shadow.bundletool.com.android.tools.r8.DexSplitterHelper;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.utils.FeatureClassMapping;
import shadow.bundletool.com.android.tools.r8.utils.OptionsParsing;

public class DexSplitter {
    private static final String DEFAULT_OUTPUT_ARCHIVE_FILENAME = "split";
    private static final boolean PRINT_ARGS = false;

    private static Options parseArguments(String[] args) throws IOException {
        Options options = new Options();
        OptionsParsing.ParseContext context = new OptionsParsing.ParseContext(args);
        while (context.head() != null) {
            List<String> input = OptionsParsing.tryParseMulti(context, "--input");
            if (input != null) {
                options.inputArchives.addAll(input);
                continue;
            }
            List<String> featureJars = OptionsParsing.tryParseMulti(context, "--feature-jar");
            if (featureJars != null) {
                options.featureJars.addAll(featureJars);
                continue;
            }
            String output = OptionsParsing.tryParseSingle(context, "--output", "-o");
            if (output != null) {
                options.splitBaseName = output;
                continue;
            }
            String proguardMap = OptionsParsing.tryParseSingle(context, "--proguard-map", null);
            if (proguardMap != null) {
                options.proguardMap = proguardMap;
                continue;
            }
            String featureSplit = OptionsParsing.tryParseSingle(context, "--feature-splits", null);
            if (featureSplit != null) {
                options.featureSplitMapping = featureSplit;
                continue;
            }
            throw new RuntimeException(String.format("Unknown options: '%s'.", context.head()));
        }
        return options;
    }

    private static FeatureClassMapping createFeatureClassMapping(Options options) throws IOException, FeatureClassMapping.FeatureMappingException, ResourceException {
        if (options.featureSplitMapping != null) {
            return FeatureClassMapping.fromSpecification(Paths.get(options.featureSplitMapping, new String[0]));
        }
        assert (!options.featureJars.isEmpty());
        return FeatureClassMapping.fromJarFiles(options.featureJars);
    }

    private static void run(String[] args) throws CompilationFailedException, IOException, CompilationException, ExecutionException, ResourceException, FeatureClassMapping.FeatureMappingException {
        Options options = DexSplitter.parseArguments(args);
        DexSplitter.run(options);
    }

    public static void run(Options options) throws IOException, FeatureClassMapping.FeatureMappingException, ResourceException, CompilationException, ExecutionException, CompilationFailedException {
        if (options.inputArchives.isEmpty()) {
            throw new RuntimeException("Need at least one --input");
        }
        if (options.featureSplitMapping == null && options.featureJars.isEmpty()) {
            throw new RuntimeException("You must supply a feature split mapping or feature jars");
        }
        if (options.featureSplitMapping != null && !options.featureJars.isEmpty()) {
            throw new RuntimeException("You can't supply both a feature split mapping and feature jars");
        }
        D8Command.Builder builder = D8Command.builder();
        for (String s : options.inputArchives) {
            builder.addProgramFiles(Paths.get(s, new String[0]));
        }
        builder.setProgramConsumer(DexIndexedConsumer.emptyConsumer());
        FeatureClassMapping featureClassMapping = DexSplitter.createFeatureClassMapping(options);
        DexSplitterHelper.run((D8Command)builder.build(), featureClassMapping, options.splitBaseName, options.proguardMap);
    }

    public static void main(String[] args) {
        try {
            DexSplitter.run(args);
        }
        catch (IOException | ExecutionException | CompilationException | CompilationFailedException | ResourceException | FeatureClassMapping.FeatureMappingException e) {
            System.err.println("Splitting failed: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void printArgs(String[] args) {
        System.err.printf("r8.DexSplitter", new Object[0]);
        for (String s : args) {
            System.err.printf(" %s", s);
        }
        System.err.println("");
    }

    public static class Options {
        List<String> inputArchives = new ArrayList<String>();
        List<String> featureJars = new ArrayList<String>();
        String splitBaseName = "split";
        String featureSplitMapping;
        String proguardMap;
    }
}

