/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfFieldInstruction;
import shadow.bundletool.com.android.tools.r8.code.Format21c;
import shadow.bundletool.com.android.tools.r8.code.Sput;
import shadow.bundletool.com.android.tools.r8.code.SputBoolean;
import shadow.bundletool.com.android.tools.r8.code.SputByte;
import shadow.bundletool.com.android.tools.r8.code.SputChar;
import shadow.bundletool.com.android.tools.r8.code.SputObject;
import shadow.bundletool.com.android.tools.r8.code.SputShort;
import shadow.bundletool.com.android.tools.r8.code.SputWide;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.MemberType;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;

public class StaticPut
extends FieldInstruction {
    public StaticPut(MemberType type, Value source, DexField field) {
        super(type, field, null, source);
    }

    public Value inValue() {
        assert (this.inValues.size() == 1);
        return (Value)this.inValues.get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format21c instruction;
        int src = builder.allocatedRegister(this.inValue(), this.getNumber());
        switch (this.type) {
            case INT: 
            case FLOAT: 
            case INT_OR_FLOAT: {
                instruction = new Sput(src, this.field);
                break;
            }
            case LONG: 
            case DOUBLE: 
            case LONG_OR_DOUBLE: {
                instruction = new SputWide(src, this.field);
                break;
            }
            case OBJECT: {
                instruction = new SputObject(src, this.field);
                break;
            }
            case BOOLEAN: {
                instruction = new SputBoolean(src, this.field);
                break;
            }
            case BYTE: {
                instruction = new SputByte(src, this.field);
                break;
            }
            case CHAR: {
                instruction = new SputChar(src, this.field);
                break;
            }
            case SHORT: {
                instruction = new SputShort(src, this.field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "StaticPut instructions define no values.";
        return 0;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        StaticPut o = other.asStaticPut();
        return o.field == this.field && o.type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        StaticPut o = other.asStaticPut();
        int result = this.field.slowCompareTo(o.field);
        if (result != 0) {
            return result;
        }
        return this.type.ordinal() - o.type.ordinal();
    }

    @Override
    DexEncodedField lookupTarget(DexType type, AppInfo appInfo) {
        return appInfo.lookupStaticTarget(type, this.field);
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.field.toSourceString();
    }

    @Override
    public boolean isStaticPut() {
        return true;
    }

    @Override
    public StaticPut asStaticPut() {
        return this;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfFieldInstruction(179, this.field));
    }
}

