/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.commands.AutoValue_BuildApksCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.io.ApkSetBuilder;
import com.android.tools.build.bundletool.io.SplitApkSerializer;
import com.android.tools.build.bundletool.io.StandaloneApkSerializer;
import com.android.tools.build.bundletool.io.TempFiles;
import com.android.tools.build.bundletool.model.Aapt2Command;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.android.tools.build.bundletool.optimizations.OptimizationsMerger;
import com.android.tools.build.bundletool.splitters.BundleSharder;
import com.android.tools.build.bundletool.splitters.ModuleSplitter;
import com.android.tools.build.bundletool.targeting.AlternativeVariantTargetingPopulator;
import com.android.tools.build.bundletool.utils.Aapt2Locator;
import com.android.tools.build.bundletool.utils.ConcurrencyUtils;
import com.android.tools.build.bundletool.utils.EnvironmentVariableProvider;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.flags.Flag;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.android.tools.build.bundletool.validation.AppBundleValidator;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.MoreFiles;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Int32Value;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;

@AutoValue
public abstract class BuildApksCommand {
    private static final int DEFAULT_THREAD_POOL_SIZE = 4;
    public static final String COMMAND_NAME = "build-apks";
    private static final Flag<Path> BUNDLE_LOCATION_FLAG = Flag.path("bundle");
    private static final Flag<Path> OUTPUT_FILE_FLAG = Flag.path("output");
    private static final Flag<ImmutableList<OptimizationDimension>> OPTIMIZE_FOR_FLAG = Flag.enumList("optimize-for", OptimizationDimension.class);
    private static final Flag<Path> AAPT2_PATH_FLAG = Flag.path("aapt2");
    private static final Flag<Boolean> GENERATE_UNIVERSAL_APK_FLAG = Flag.booleanFlag("universal");
    private static final Flag<Integer> MAX_THREADS_FLAG = Flag.positiveInteger("max-threads");
    private static final Flag<Path> KEYSTORE_FLAG = Flag.path("ks");
    private static final Flag<String> KEY_ALIAS_FLAG = Flag.string("ks-key-alias");
    private static final Flag<Flag.Password> KEYSTORE_PASSWORD = Flag.password("ks-pass");
    private static final Flag<Flag.Password> KEY_PASSWORD = Flag.password("key-pass");
    private static final Commands.ModuleMetadata STANDALONE_MODULE_METADATA = Commands.ModuleMetadata.newBuilder().setName("base").build();
    private static final String APK_SET_ARCHIVE_EXTENSION = "apks";

    public abstract Path getBundlePath();

    public abstract Path getOutputFile();

    public abstract ImmutableSet<OptimizationDimension> getOptimizationDimensions();

    public abstract boolean getGenerateOnlyUniversalApk();

    public abstract Aapt2Command getAapt2Command();

    public abstract Optional<SigningConfiguration> getSigningConfiguration();

    public abstract ListeningExecutorService getExecutorService();

    public static Builder builder() {
        return new AutoValue_BuildApksCommand.Builder().setGenerateOnlyUniversalApk(false).setOptimizationDimensions((ImmutableSet<OptimizationDimension>)ImmutableSet.of()).setExecutorService(BuildApksCommand.createInternalExecutorService(4));
    }

    public static BuildApksCommand fromFlags(ParsedFlags flags, EnvironmentVariableProvider environmentVariableProvider) {
        return BuildApksCommand.fromFlags(flags, environmentVariableProvider, System.out);
    }

    public static BuildApksCommand fromFlags(ParsedFlags flags, EnvironmentVariableProvider environmentVariableProvider, PrintStream out) {
        Path aapt2Path = BuildApksCommand.locateAapt2(flags, environmentVariableProvider);
        Builder buildApksCommand = BuildApksCommand.builder().setBundlePath(BUNDLE_LOCATION_FLAG.getRequiredValue(flags)).setOutputFile(OUTPUT_FILE_FLAG.getRequiredValue(flags)).setAapt2Command(Aapt2Command.createFromExecutablePath(aapt2Path));
        GENERATE_UNIVERSAL_APK_FLAG.getValue(flags).ifPresent(buildApksCommand::setGenerateOnlyUniversalApk);
        MAX_THREADS_FLAG.getValue(flags).ifPresent(maxThreads -> buildApksCommand.setExecutorService(BuildApksCommand.createInternalExecutorService(maxThreads)));
        OPTIMIZE_FOR_FLAG.getValue(flags).ifPresent(values -> buildApksCommand.setOptimizationDimensions((ImmutableSet<OptimizationDimension>)ImmutableSet.copyOf((Collection)values)));
        Optional<Path> keystorePath = KEYSTORE_FLAG.getValue(flags);
        Optional<String> keyAlias = KEY_ALIAS_FLAG.getValue(flags);
        Optional<Flag.Password> keystorePassword = KEYSTORE_PASSWORD.getValue(flags);
        Optional<Flag.Password> keyPassword = KEY_PASSWORD.getValue(flags);
        if (keystorePath.isPresent() && keyAlias.isPresent()) {
            buildApksCommand.setSigningConfiguration(SigningConfiguration.extractFromKeystore(keystorePath.get(), keyAlias.get(), keystorePassword, keyPassword));
        } else {
            if (keystorePath.isPresent() && !keyAlias.isPresent()) {
                throw new CommandExecutionException("Flag --ks-key-alias is required when --ks is set.");
            }
            if (!keystorePath.isPresent() && keyAlias.isPresent()) {
                throw new CommandExecutionException("Flag --ks is required when --ks-key-alias is set.");
            }
            out.println("WARNING: The APKs won't be signed and thus not installable unless you also pass a keystore via the flag --ks. See the command help for more information.");
        }
        flags.checkNoUnknownFlags();
        return buildApksCommand.build();
    }

    public Path execute() {
        return TempFiles.withTempDirectoryReturning(this::executeWithTempDir);
    }

    private Path executeWithTempDir(Path tempDir) {
        this.validateInput();
        try (ZipFile bundleZip = new ZipFile(this.getBundlePath().toFile());){
            boolean generateStandaloneApks;
            AppBundle appBundle = AppBundle.buildFromZip(bundleZip);
            new AppBundleValidator().validate(appBundle);
            Config.BundleConfig bundleConfig = appBundle.getBundleConfig();
            ImmutableList allModules = ImmutableList.copyOf((Collection)appBundle.getModules().values());
            ApkSetBuilder apkSetBuilder = new ApkSetBuilder(new SplitApkSerializer(this.getAapt2Command(), this.getSigningConfiguration(), bundleConfig.getCompression()), new StandaloneApkSerializer(this.getAapt2Command(), this.getSigningConfiguration(), bundleConfig.getCompression()), tempDir);
            ApkOptimizations apkOptimizations = this.getGenerateOnlyUniversalApk() ? ApkOptimizations.getOptimizationsForUniversalApk() : new OptimizationsMerger().mergeWithDefaults(appBundle.getBundleConfig(), this.getOptimizationDimensions());
            ImmutableList<Commands.Variant> splitApkVariants = ImmutableList.of();
            ImmutableList<Commands.Variant> standaloneVariants = ImmutableList.of();
            boolean generateSplitApks = !this.getGenerateOnlyUniversalApk() && !BuildApksCommand.targetsOnlyPreL(appBundle);
            boolean bl = generateStandaloneApks = this.getGenerateOnlyUniversalApk() || BuildApksCommand.targetsPreL(appBundle);
            if (generateSplitApks) {
                splitApkVariants = this.generateSplitApkVariants((ImmutableList<BundleModule>)allModules, apkSetBuilder, apkOptimizations);
            }
            if (generateStandaloneApks) {
                ImmutableList modulesForFusing = (ImmutableList)allModules.stream().filter(BundleModule::isIncludedInFusing).collect(ImmutableList.toImmutableList());
                standaloneVariants = this.generateStandaloneApkVariants((ImmutableList<BundleModule>)modulesForFusing, appBundle.getBundleMetadata(), this.getGenerateOnlyUniversalApk(), tempDir, apkSetBuilder, apkOptimizations);
            }
            ImmutableList<Commands.Variant> allVariantsWithTargeting = AlternativeVariantTargetingPopulator.populateAlternativeVariantTargeting(splitApkVariants, standaloneVariants);
            apkSetBuilder.addTableOfContentsFile(Commands.BuildApksResult.newBuilder().addAllVariant((Iterable<? extends Commands.Variant>)allVariantsWithTargeting).build());
            apkSetBuilder.writeTo(this.getOutputFile());
        }
        catch (IOException e) {
            throw ValidationException.builder().withCause(e).withMessage("Error reading zip file '%s'.", this.getBundlePath()).build();
        }
        return this.getOutputFile();
    }

    private void validateInput() {
        FilePreconditions.checkFileExistsAndReadable(this.getBundlePath());
        FilePreconditions.checkFileDoesNotExist(this.getOutputFile());
    }

    private ImmutableList<Commands.Variant> generateSplitApkVariants(ImmutableList<BundleModule> modules, ApkSetBuilder apkSetBuilder, ApkOptimizations apkOptimizations) {
        Commands.Variant.Builder variant = Commands.Variant.newBuilder().setTargeting(BuildApksCommand.lPlusVariantTargeting());
        for (BundleModule module : modules) {
            ImmutableList<ModuleSplit> splitApks = new ModuleSplitter(module, apkOptimizations.getSplitDimensions()).splitModule();
            ImmutableList apkDescriptions = ConcurrencyUtils.waitForAll((Iterable)splitApks.stream().map(splitApk -> this.getExecutorService().submit(() -> apkSetBuilder.addSplitApk((ModuleSplit)splitApk))).collect(ImmutableList.toImmutableList()));
            variant.addApkSet(Commands.ApkSet.newBuilder().setModuleMetadata(module.getModuleMetadata()).addAllApkDescription((Iterable<? extends Commands.ApkDescription>)apkDescriptions).build());
        }
        return ImmutableList.of((Object)variant.build());
    }

    private ImmutableList<Commands.Variant> generateStandaloneApkVariants(ImmutableList<BundleModule> modules, BundleMetadata bundleMetadata, boolean isUniversalApk, Path tempDir, ApkSetBuilder apkSetBuilder, ApkOptimizations apkOptimizations) {
        ImmutableList<ModuleSplit> standaloneApks = new BundleSharder(tempDir).shardBundle(modules, apkOptimizations.getSplitDimensions(), bundleMetadata);
        return ConcurrencyUtils.waitForAll((Iterable)standaloneApks.stream().map(standaloneApk -> this.getExecutorService().submit(() -> this.writeStandaloneApkVariant((ModuleSplit)standaloneApk, isUniversalApk, apkSetBuilder))).collect(ImmutableList.toImmutableList()));
    }

    private Commands.Variant writeStandaloneApkVariant(ModuleSplit standaloneApk, boolean isUniversalApk, ApkSetBuilder apkSetBuilder) {
        Commands.ApkDescription apkDescription = isUniversalApk ? apkSetBuilder.addStandaloneUniversalApk(standaloneApk) : apkSetBuilder.addStandaloneApk(standaloneApk);
        return Commands.Variant.newBuilder().setTargeting(isUniversalApk ? Targeting.VariantTargeting.getDefaultInstance() : BuildApksCommand.standaloneApkVariantTargeting(standaloneApk)).addApkSet(Commands.ApkSet.newBuilder().setModuleMetadata(STANDALONE_MODULE_METADATA).addApkDescription(apkDescription)).build();
    }

    private static boolean targetsOnlyPreL(AppBundle bundle) {
        Optional<Integer> maxSdkVersion = bundle.getBaseModule().getAndroidManifest().getMaxSdkVersion();
        return maxSdkVersion.isPresent() && maxSdkVersion.get() < 21;
    }

    private static boolean targetsPreL(AppBundle bundle) {
        int baseMinSdkVersion = bundle.getBaseModule().getAndroidManifest().getEffectiveMinSdkVersion();
        return baseMinSdkVersion < 21;
    }

    private static Targeting.VariantTargeting lPlusVariantTargeting() {
        return Targeting.VariantTargeting.newBuilder().setSdkVersionTargeting(Targeting.SdkVersionTargeting.newBuilder().addValue(Targeting.SdkVersion.newBuilder().setMin(Int32Value.newBuilder().setValue(21)))).build();
    }

    private static Path locateAapt2(ParsedFlags flags, EnvironmentVariableProvider environmentVariableProvider) {
        Optional<Path> aapt2Path = AAPT2_PATH_FLAG.getValue(flags);
        if (aapt2Path.isPresent()) {
            FilePreconditions.checkFileExistsAndExecutable(aapt2Path.get());
            return aapt2Path.get();
        }
        Optional<Path> androidHomePath = environmentVariableProvider.getAndroidHomePath().map(x$0 -> Paths.get(x$0, new String[0]));
        if (!androidHomePath.isPresent()) {
            throw CommandExecutionException.builder().withMessage("The --%s flag must be set with the path to aapt2, or the '%s' environment variable must be set to the path of the SDK.", AAPT2_PATH_FLAG, "ANDROID_HOME").build();
        }
        return new Aapt2Locator().locateAapt2(androidHomePath.get()).orElseThrow(() -> CommandExecutionException.builder().withMessage("Unable to find aapt2 in SDK directory. Please set the --%s flag.", AAPT2_PATH_FLAG).build());
    }

    private static Targeting.VariantTargeting standaloneApkVariantTargeting(ModuleSplit standaloneApk) {
        Targeting.ApkTargeting apkTargeting = standaloneApk.getTargeting();
        Targeting.VariantTargeting.Builder variantTargeting = Targeting.VariantTargeting.newBuilder();
        if (apkTargeting.hasAbiTargeting()) {
            variantTargeting.setAbiTargeting(apkTargeting.getAbiTargeting());
        }
        if (apkTargeting.hasScreenDensityTargeting()) {
            variantTargeting.setScreenDensityTargeting(apkTargeting.getScreenDensityTargeting());
        }
        variantTargeting.setSdkVersionTargeting(Targeting.SdkVersionTargeting.newBuilder().addValue(Targeting.SdkVersion.getDefaultInstance()));
        return variantTargeting.build();
    }

    private static ListeningExecutorService createInternalExecutorService(int maxThreads) {
        Preconditions.checkArgument((maxThreads >= 0 ? 1 : 0) != 0, (String)"The maxThreads must be positive, got %s.", (int)maxThreads);
        return MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(maxThreads));
    }

    public static void help() {
        CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription("Generates an APK Set archive containing all possible split APKs and standalone APKs.").addFlag(CommandHelp.FlagDescription.builder().setFlagName(BUNDLE_LOCATION_FLAG.getName()).setExampleValue("bundle.aab").setDescription("Path to the Android App Bundle to generate APKs from.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_FILE_FLAG.getName()).setExampleValue("output.apks").setDescription("Path to where the APK Set archive should be created.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(AAPT2_PATH_FLAG.getName()).setExampleValue("path/to/aapt2").setOptional(true).setDescription("Path to the aapt2 binary. Can be omitted if the '%s' environment variable is set.", "ANDROID_HOME").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(GENERATE_UNIVERSAL_APK_FLAG.getName()).setOptional(true).setDescription("If set, will generate only a single universal APK. This flag is mutually exclusive with flag --%s.", OPTIMIZE_FOR_FLAG.getName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(MAX_THREADS_FLAG.getName()).setExampleValue("num-threads").setOptional(true).setDescription("Sets the maximum number of threads to use (default: %d).", 4).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OPTIMIZE_FOR_FLAG.getName()).setExampleValue(BuildApksCommand.joinFlagOptions(OptimizationDimension.values())).setOptional(true).setDescription("If set, will generate APKs with optimizations for the given dimensions. Acceptable values are '%s'. This flag is mutually exclusive with flag --%s.", BuildApksCommand.joinFlagOptions(OptimizationDimension.values()), GENERATE_UNIVERSAL_APK_FLAG.getName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEYSTORE_FLAG.getName()).setExampleValue("path/to/keystore").setOptional(true).setDescription("Path to the keystore that should be used to sign the generated APKs. If not set, the APKs will not be signed. If set, the flag '%s' must also be set.", KEY_ALIAS_FLAG).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEY_ALIAS_FLAG.getName()).setExampleValue("key-alias").setOptional(true).setDescription("Alias of the key to use in the keystore to sign the generated APKs.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEYSTORE_PASSWORD.getName()).setExampleValue("[pass|file]:value").setOptional(true).setDescription("Password of the keystore to use to sign the generated APKs. If provided, must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this flag is not set, the password will be requested on the prompt.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEY_PASSWORD.getName()).setExampleValue("key-password").setOptional(true).setDescription("Password of the key in the keystore to use to sign the generated APKs. If provided, must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this flag is not set, the keystore password will be tried. If that fails, the password will be requested on the prompt.").build()).build().print(System.out);
    }

    private static String joinFlagOptions(Enum<?> ... flagOptions) {
        return Arrays.stream(flagOptions).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining("|"));
    }

    public static abstract class Builder {
        public abstract Builder setBundlePath(Path var1);

        public abstract Builder setOutputFile(Path var1);

        @Deprecated
        public abstract Builder setOptimizationDimensions(ImmutableSet<OptimizationDimension> var1);

        public abstract Builder setGenerateOnlyUniversalApk(boolean var1);

        public abstract Builder setAapt2Command(Aapt2Command var1);

        public abstract Builder setSigningConfiguration(SigningConfiguration var1);

        public abstract Builder setExecutorService(ListeningExecutorService var1);

        abstract BuildApksCommand autoBuild();

        public BuildApksCommand build() {
            BuildApksCommand command = this.autoBuild();
            if (!command.getOptimizationDimensions().isEmpty() && command.getGenerateOnlyUniversalApk()) {
                throw new ValidationException("Cannot generate universal APK and specify optimization dimensions at the same time.");
            }
            if (!BuildApksCommand.APK_SET_ARCHIVE_EXTENSION.equals(MoreFiles.getFileExtension((Path)command.getOutputFile()))) {
                throw ValidationException.builder().withMessage("Flag --%s should be the path where to generate the APK Set. Its extension must be '.apks'.", OUTPUT_FILE_FLAG).build();
            }
            return command;
        }
    }
}

