/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Devices;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import shadow.bundletool.com.android.ddmlib.AndroidDebugBridge;

public class DeviceAnalyzer {
    private final AndroidDebugBridge adb;
    private static final int ADB_CONNECTION_TIMEOUT_MS = 60000;

    public DeviceAnalyzer(AndroidDebugBridge adb) {
        this.adb = adb;
    }

    public Devices.DeviceSpec analyzeDevice() {
        try {
            this.waitTillAdbConnected(60000L);
            return Devices.DeviceSpec.getDefaultInstance();
        }
        catch (TimeoutException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("Timed out while waiting for ADB.").build();
        }
    }

    private void waitTillAdbConnected(long timeoutMs) throws TimeoutException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Thread.sleep(50L);
            while (!this.adb.isConnected()) {
                if (stopwatch.elapsed(TimeUnit.MILLISECONDS) > timeoutMs) {
                    throw new TimeoutException(String.format("Timed out (%d ms) while waiting for ADB.", timeoutMs));
                }
                Thread.sleep(1000L);
            }
            System.out.println("Connected to ADB.");
        }
        catch (InterruptedException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("Interrupted while waiting for ADB.").build();
        }
    }
}

