/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.io.ZipBuilder;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.InputStreamSupplier;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;

public class AppBundleSerializer {
    public void writeToDisk(AppBundle bundle, Path pathOnDisk) throws IOException {
        ZipBuilder zipBuilder = new ZipBuilder();
        zipBuilder.addFileWithProtoContent(ZipPath.create("BundleConfig.pb"), (MessageLite)bundle.getBundleConfig(), new ZipBuilder.EntryOption[0]);
        for (Map.Entry metadataEntry : bundle.getBundleMetadata().getFileDataMap().entrySet()) {
            zipBuilder.addFile(AppBundle.METADATA_DIRECTORY.resolve((Path)metadataEntry.getKey()), (InputStreamSupplier)metadataEntry.getValue(), new ZipBuilder.EntryOption[0]);
        }
        for (BundleModule module : bundle.getModules().values()) {
            for (ModuleEntry entry : module.getEntries()) {
                ZipPath entryPath = ZipPath.create(module.getName().toString()).resolve(entry.getPath());
                if (entry.isDirectory()) {
                    zipBuilder.addDirectory(entryPath);
                    continue;
                }
                zipBuilder.addFile(entryPath, () -> entry.getContent(), new ZipBuilder.EntryOption[0]);
            }
        }
        zipBuilder.writeTo(pathOnDisk);
    }
}

