/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.targeting;

import com.android.bundle.Commands;
import com.android.bundle.Targeting;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.annotation.CheckReturnValue;

public abstract class AlternativeVariantTargetingPopulator<T extends Message> {
    public static ImmutableList<Commands.Variant> populateAlternativeVariantTargeting(ImmutableList<Commands.Variant> splitApkVariants, ImmutableList<Commands.Variant> standaloneVariants) {
        standaloneVariants = new AbiAlternativesPopulator().addAlternativeVariantTargeting(standaloneVariants);
        standaloneVariants = new ScreenDensityAlternativesPopulator().addAlternativeVariantTargeting(standaloneVariants);
        return new SdkVersionAlternativesPopulator().addAlternativeVariantTargeting(splitApkVariants, standaloneVariants);
    }

    @CheckReturnValue
    ImmutableList<Commands.Variant> addAlternativeVariantTargeting(ImmutableList<Commands.Variant> ... variants) {
        return this.addAlternativeVariantTargeting((ImmutableList<Commands.Variant>)((ImmutableList)Arrays.stream(variants).flatMap(Collection::stream).collect(ImmutableList.toImmutableList())));
    }

    @CheckReturnValue
    ImmutableList<Commands.Variant> addAlternativeVariantTargeting(ImmutableList<Commands.Variant> variants) {
        ImmutableSet dimensionIsTargeted = (ImmutableSet)variants.stream().map(variant -> !this.getValues(variant.getTargeting()).isEmpty()).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkArgument((dimensionIsTargeted.size() <= 1 ? 1 : 0) != 0, (Object)"Some variants are agnostic to the dimension, and some are not.");
        if (variants.isEmpty() || !((Boolean)Iterables.getOnlyElement((Iterable)dimensionIsTargeted)).booleanValue()) {
            return variants;
        }
        ImmutableSet allValues = (ImmutableSet)variants.stream().flatMap(variant -> this.getValues(variant.getTargeting()).stream()).collect(ImmutableSet.toImmutableSet());
        return (ImmutableList)variants.stream().map(variant -> {
            Commands.Variant.Builder result = variant.toBuilder();
            this.setDimensionAlternatives(result.getTargetingBuilder(), (ImmutableCollection<T>)ImmutableSet.copyOf((Collection)Sets.difference((Set)allValues, (Set)ImmutableSet.copyOf(this.getValues(variant.getTargeting())))));
            return result.build();
        }).collect(ImmutableList.toImmutableList());
    }

    protected abstract ImmutableList<T> getValues(Targeting.VariantTargeting var1);

    protected abstract void setDimensionAlternatives(Targeting.VariantTargeting.Builder var1, ImmutableCollection<T> var2);

    @VisibleForTesting
    static class SdkVersionAlternativesPopulator
    extends AlternativeVariantTargetingPopulator<Targeting.SdkVersion> {
        SdkVersionAlternativesPopulator() {
        }

        @Override
        protected ImmutableList<Targeting.SdkVersion> getValues(Targeting.VariantTargeting targeting) {
            return ImmutableList.copyOf(targeting.getSdkVersionTargeting().getValueList());
        }

        @Override
        protected void setDimensionAlternatives(Targeting.VariantTargeting.Builder targetingBuilder, ImmutableCollection<Targeting.SdkVersion> alternatives) {
            targetingBuilder.getSdkVersionTargetingBuilder().clearAlternatives().addAllAlternatives((Iterable<? extends Targeting.SdkVersion>)alternatives);
        }
    }

    @VisibleForTesting
    static class ScreenDensityAlternativesPopulator
    extends AlternativeVariantTargetingPopulator<Targeting.ScreenDensity> {
        ScreenDensityAlternativesPopulator() {
        }

        @Override
        protected ImmutableList<Targeting.ScreenDensity> getValues(Targeting.VariantTargeting targeting) {
            return ImmutableList.copyOf(targeting.getScreenDensityTargeting().getValueList());
        }

        @Override
        protected void setDimensionAlternatives(Targeting.VariantTargeting.Builder targetingBuilder, ImmutableCollection<Targeting.ScreenDensity> alternatives) {
            targetingBuilder.getScreenDensityTargetingBuilder().clearAlternatives().addAllAlternatives((Iterable<? extends Targeting.ScreenDensity>)alternatives);
        }
    }

    @VisibleForTesting
    static class AbiAlternativesPopulator
    extends AlternativeVariantTargetingPopulator<Targeting.Abi> {
        AbiAlternativesPopulator() {
        }

        @Override
        protected ImmutableList<Targeting.Abi> getValues(Targeting.VariantTargeting targeting) {
            return ImmutableList.copyOf(targeting.getAbiTargeting().getValueList());
        }

        @Override
        protected void setDimensionAlternatives(Targeting.VariantTargeting.Builder targetingBuilder, ImmutableCollection<Targeting.Abi> alternatives) {
            targetingBuilder.getAbiTargetingBuilder().clearAlternatives().addAllAlternatives((Iterable<? extends Targeting.Abi>)alternatives);
        }
    }
}

