/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.build.apkzlib.zip;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.AlignmentRule;

public final class AlignmentRules {
    private AlignmentRules() {
    }

    public static AlignmentRule constant(int alignment) {
        Preconditions.checkArgument((alignment > 0 ? 1 : 0) != 0, (Object)"alignment <= 0");
        return path -> alignment;
    }

    public static AlignmentRule constantForSuffix(@Nonnull String suffix, int alignment) {
        Preconditions.checkArgument((!suffix.isEmpty() ? 1 : 0) != 0, (Object)"suffix.isEmpty()");
        Preconditions.checkArgument((alignment > 0 ? 1 : 0) != 0, (Object)"alignment <= 0");
        return path -> path.endsWith(suffix) ? alignment : 1;
    }

    public static AlignmentRule compose(AlignmentRule ... rules) {
        return path -> {
            for (AlignmentRule r : rules) {
                int align = r.alignment(path);
                if (align == 1) continue;
                return align;
            }
            return 1;
        };
    }
}

