/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import shadow.bundletool.com.android.tools.r8.BaseCompilerCommand;
import shadow.bundletool.com.android.tools.r8.ClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.ClassFileResourceProvider;
import shadow.bundletool.com.android.tools.r8.CompilationMode;
import shadow.bundletool.com.android.tools.r8.DexFilePerClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.DexIndexedConsumer;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.OutputMode;
import shadow.bundletool.com.android.tools.r8.ProgramConsumer;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class D8Command
extends BaseCompilerCommand {
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"Usage: d8 [options] <input-files>", (Object)" where <input-files> are any combination of dex, class, zip, jar, or apk files", (Object)" and options are:", (Object)"  --debug                 # Compile with debugging information (default).", (Object)"  --release               # Compile without debugging information.", (Object)"  --output <file>         # Output result in <outfile>.", (Object)"                          # <file> must be an existing directory or a zip file.", (Object)"  --lib <file>            # Add <file> as a library resource.", (Object)"  --classpath <file>      # Add <file> as a classpath resource.", (Object)"  --min-api               # Minimum Android API level compatibility", (Object)"  --intermediate          # Compile an intermediate result intended for later", (Object)"                          # merging.", (Object[])new String[]{"  --file-per-class        # Produce a separate dex file per input class", "  --no-desugaring         # Force disable desugaring.", "  --main-dex-list <file>  # List of classes to place in the primary dex file.", "  --version               # Print the version of d8.", "  --help                  # Print this message."}));
    private boolean intermediate = false;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    public static Builder parse(String[] args, Origin origin) {
        return D8Command.parse(args, origin, D8Command.builder());
    }

    public static Builder parse(String[] args, Origin origin, DiagnosticsHandler handler) {
        return D8Command.parse(args, origin, D8Command.builder(handler));
    }

    private static Builder parse(String[] args, Origin origin, Builder builder) {
        CompilationMode compilationMode = null;
        Path outputPath = null;
        OutputMode outputMode = null;
        boolean hasDefinedApiLevel = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.equals("--version")) {
                    builder.setPrintVersion(true);
                    continue;
                }
                if (arg.equals("--debug")) {
                    if (compilationMode == CompilationMode.RELEASE) {
                        builder.getReporter().error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", origin));
                        continue;
                    }
                    compilationMode = CompilationMode.DEBUG;
                    continue;
                }
                if (arg.equals("--release")) {
                    if (compilationMode == CompilationMode.DEBUG) {
                        builder.getReporter().error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", origin));
                        continue;
                    }
                    compilationMode = CompilationMode.RELEASE;
                    continue;
                }
                if (arg.equals("--file-per-class")) {
                    outputMode = OutputMode.DexFilePerClassFile;
                    continue;
                }
                if (arg.equals("--output")) {
                    String output = args[++i];
                    if (outputPath != null) {
                        builder.getReporter().error(new StringDiagnostic("Cannot output both to '" + outputPath.toString() + "' and '" + output + "'", origin));
                        continue;
                    }
                    outputPath = Paths.get(output, new String[0]);
                    continue;
                }
                if (arg.equals("--lib")) {
                    builder.addLibraryFiles(Paths.get(args[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--classpath")) {
                    builder.addClasspathFiles(Paths.get(args[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--main-dex-list")) {
                    builder.addMainDexListFiles(Paths.get(args[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--min-api")) {
                    hasDefinedApiLevel = D8Command.parseMinApi(builder, args[++i], hasDefinedApiLevel, origin);
                    continue;
                }
                if (arg.equals("--intermediate")) {
                    builder.setIntermediate(true);
                    continue;
                }
                if (arg.equals("--no-desugaring")) {
                    builder.setDisableDesugaring(true);
                    continue;
                }
                if (arg.startsWith("--")) {
                    builder.getReporter().error(new StringDiagnostic("Unknown option: " + arg, origin));
                    continue;
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
            if (compilationMode != null) {
                builder.setMode(compilationMode);
            }
            if (outputMode == null) {
                outputMode = OutputMode.DexIndexed;
            }
            if (outputPath == null) {
                outputPath = Paths.get(".", new String[0]);
            }
            return (Builder)builder.setOutput(outputPath, outputMode);
        }
        catch (CompilationError e) {
            throw builder.getReporter().fatalError(e);
        }
    }

    private D8Command(AndroidApp inputApp, CompilationMode mode, ProgramConsumer programConsumer, int minApiLevel, Reporter diagnosticsHandler, boolean enableDesugaring, boolean intermediate) {
        super(inputApp, mode, programConsumer, minApiLevel, diagnosticsHandler, enableDesugaring);
        this.intermediate = intermediate;
    }

    private D8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(new DexItemFactory(), this.getReporter());
        assert (!internal.debug);
        internal.debug = this.getMode() == CompilationMode.DEBUG;
        internal.programConsumer = this.getProgramConsumer();
        internal.minimalMainDex = internal.debug;
        internal.minApiLevel = this.getMinApiLevel();
        internal.intermediate = this.intermediate;
        assert (internal.enableMinification);
        internal.enableMinification = false;
        assert (internal.enableTreeShaking);
        internal.enableTreeShaking = false;
        assert (!internal.passthroughDexCode);
        internal.passthroughDexCode = true;
        assert (internal.enableInlining);
        internal.enableInlining = false;
        assert (internal.enableSwitchMapRemoval);
        internal.enableSwitchMapRemoval = false;
        assert (internal.outline.enabled);
        internal.outline.enabled = false;
        assert (internal.enableValuePropagation);
        internal.enableValuePropagation = false;
        internal.enableDesugaring = this.getEnableDesugaring();
        return internal;
    }

    public static class Builder
    extends BaseCompilerCommand.Builder<D8Command, Builder> {
        private boolean intermediate = false;

        Builder() {
            this.setMode(CompilationMode.DEBUG);
        }

        Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
            this.setMode(CompilationMode.DEBUG);
        }

        private Builder(AndroidApp app) {
            super(app);
            this.setMode(CompilationMode.DEBUG);
        }

        public Builder addDexProgramData(byte[] data, Origin origin) {
            this.guard(() -> this.getAppBuilder().addDexProgramData(data, origin));
            return this.self();
        }

        public Builder addClasspathFiles(Path ... files) {
            this.guard(() -> Arrays.stream(files).forEach(this::addClasspathFile));
            return this.self();
        }

        public Builder addClasspathFiles(Collection<Path> files) {
            this.guard(() -> files.forEach(this::addClasspathFile));
            return this.self();
        }

        private void addClasspathFile(Path file) {
            this.guard(() -> {
                try {
                    this.getAppBuilder().addClasspathFile(file);
                }
                catch (IOException e) {
                    this.error("Error with classpath entry: ", file, e);
                }
            });
        }

        public Builder addClasspathResourceProvider(ClassFileResourceProvider provider) {
            this.guard(() -> this.getAppBuilder().addClasspathResourceProvider(provider));
            return this.self();
        }

        public Builder setIntermediate(boolean value) {
            this.intermediate = value;
            return this.self();
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        void validate() {
            Reporter reporter = this.getReporter();
            if (this.getProgramConsumer() instanceof ClassFileConsumer) {
                reporter.error("D8 does not support compiling to Java class files");
            }
            if (this.getAppBuilder().hasMainDexList()) {
                if (this.intermediate) {
                    reporter.error("Option --main-dex-list cannot be used with --intermediate");
                }
                if (this.getProgramConsumer() instanceof DexFilePerClassFileConsumer) {
                    reporter.error("Option --main-dex-list cannot be used with --file-per-class");
                }
            }
            super.validate();
        }

        @Override
        D8Command makeCommand() {
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new D8Command(this.isPrintHelp(), this.isPrintVersion());
            }
            this.intermediate |= this.getProgramConsumer() instanceof DexFilePerClassFileConsumer;
            return new D8Command(this.getAppBuilder().build(), this.getMode(), this.getProgramConsumer(), this.getMinApiLevel(), this.getReporter(), !this.getDisableDesugaring(), this.intermediate);
        }

        private static DexIndexedConsumer createIndexedConsumer(Path path) {
            if (path == null) {
                return DexIndexedConsumer.emptyConsumer();
            }
            return FileUtils.isArchive(path) ? new DexIndexedConsumer.ArchiveConsumer(path) : new DexIndexedConsumer.DirectoryConsumer(path);
        }

        private static DexFilePerClassFileConsumer createPerClassFileConsumer(Path path) {
            if (path == null) {
                return DexFilePerClassFileConsumer.emptyConsumer();
            }
            return FileUtils.isArchive(path) ? new DexFilePerClassFileConsumer.ArchiveConsumer(path) : new DexFilePerClassFileConsumer.DirectoryConsumer(path);
        }
    }
}

