/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.HashMap;
import shadow.bundletool.com.android.tools.r8.BaseCommand;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.dex.DexParser;
import shadow.bundletool.com.android.tools.r8.dex.DexSection;
import shadow.bundletool.com.android.tools.r8.origin.CommandLineOrigin;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class DexSegments {
    public static void main(String[] args) throws IOException, CompilationFailedException, ResourceException {
        Command.Builder builder = Command.parse(args);
        Command command = (Command)builder.build();
        if (command.isPrintHelp()) {
            System.out.println(Command.USAGE_MESSAGE);
            return;
        }
        AndroidApp app = command.getInputApp();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try (Closer closer = Closer.create();){
            for (ProgramResource resource : app.computeAllProgramResources()) {
                if (resource.getKind() != ProgramResource.Kind.DEX) continue;
                for (DexSection dexSection : DexParser.parseMapFrom((InputStream)closer.register((Closeable)resource.getByteStream()), resource.getOrigin())) {
                    int value2 = result.computeIfAbsent(dexSection.typeName(), key -> 0);
                    result.put(dexSection.typeName(), value2 + dexSection.size());
                }
            }
        }
        System.out.println("Segments in dex application (name: size):");
        result.forEach((key, value) -> System.out.println(" - " + key + ": " + value));
    }

    private static class Command
    extends BaseCommand {
        static final String USAGE_MESSAGE = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"Usage: dexsegments [options] <input-files>", (Object)" where <input-files> are dex files", (Object)"  --version               # Print the version of r8.", (Object)"  --help                  # Print this message."));

        public static Builder builder() {
            return new Builder();
        }

        public static Builder parse(String[] args) {
            Builder builder = Command.builder();
            Command.parse(args, builder);
            return builder;
        }

        private static void parse(String[] args, Builder builder) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.startsWith("--")) {
                    builder.getReporter().error(new StringDiagnostic("Unknown option: " + arg, CommandLineOrigin.INSTANCE));
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
        }

        private Command(AndroidApp inputApp) {
            super(inputApp);
        }

        private Command(boolean printHelp) {
            super(printHelp, false);
        }

        @Override
        InternalOptions getInternalOptions() {
            return new InternalOptions();
        }

        public static class Builder
        extends BaseCommand.Builder<Command, Builder> {
            @Override
            Builder self() {
                return this;
            }

            @Override
            protected Command makeCommand() {
                if (this.isPrintHelp()) {
                    return new Command(this.isPrintHelp());
                }
                return new Command(this.getAppBuilder().build());
            }
        }
    }
}

