/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.CompilationException;
import shadow.bundletool.com.android.tools.r8.D8;
import shadow.bundletool.com.android.tools.r8.D8Command;
import shadow.bundletool.com.android.tools.r8.DexIndexedConsumer;
import shadow.bundletool.com.android.tools.r8.R8;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationWriter;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.utils.FeatureClassMapping;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class DexSplitterHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(D8Command command, FeatureClassMapping featureClassMapping, String outputArchive, String proguardMap) throws IOException, CompilationException, ExecutionException {
        InternalOptions options = command.getInternalOptions();
        options.enableDesugaring = false;
        options.enableMainDexListCheck = false;
        options.minimalMainDex = false;
        options.enableMinification = false;
        options.enableInlining = false;
        options.outline.enabled = false;
        ExecutorService executor = ThreadUtils.getExecutorService(-1);
        try {
            try {
                Timing timing = new Timing("DexSplitter");
                DexApplication app = new ApplicationReader(command.getInputApp(), options, timing).read(null, executor);
                ClassNameMapper mapper = null;
                if (proguardMap != null) {
                    mapper = ClassNameMapper.mapperFromFile(Paths.get(proguardMap, new String[0]));
                }
                Map<String, DexApplication.Builder> applications = DexSplitterHelper.getDistribution(app, featureClassMapping, mapper);
                for (Map.Entry<String, DexApplication.Builder> entry : applications.entrySet()) {
                    DexApplication featureApp = entry.getValue().build();
                    featureApp.dexItemFactory.resetSortedIndices();
                    assert (!options.hasMethodsFilter());
                    AppInfo appInfo = new AppInfo(featureApp);
                    featureApp = D8.optimize(featureApp, appInfo, options, timing, executor);
                    DexIndexedConsumer.ArchiveConsumer consumer = new DexIndexedConsumer.ArchiveConsumer(Paths.get(outputArchive + "." + entry.getKey() + ".zip", new String[0]));
                    try {
                        new ApplicationWriter(featureApp, options, D8.getMarker(options), null, NamingLens.getIdentityLens(), null, null, consumer).write(executor);
                        options.printWarnings();
                    }
                    finally {
                        consumer.finished(options.reporter);
                    }
                }
            }
            catch (ExecutionException e) {
                R8.unwrapExecutionException(e);
                throw new AssertionError((Object)e);
            }
            catch (FeatureClassMapping.FeatureMappingException e) {
                options.reporter.error(e.getMessage());
            }
            finally {
                options.signalFinishedToProgramConsumer();
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private static Map<String, DexApplication.Builder> getDistribution(DexApplication app, FeatureClassMapping featureClassMapping, ClassNameMapper mapper) throws FeatureClassMapping.FeatureMappingException {
        HashMap<String, DexApplication.Builder> applications = new HashMap<String, DexApplication.Builder>();
        for (DexProgramClass clazz : app.classes()) {
            String clazzName = mapper != null ? mapper.deobfuscateClassName(clazz.toString()) : clazz.toString();
            String feature = featureClassMapping.featureForClass(clazzName);
            DexApplication.Builder featureApplication = (DexApplication.Builder)applications.get(feature);
            if (featureApplication == null) {
                featureApplication = DexApplication.builder(app.dexItemFactory, app.timing);
                applications.put(feature, featureApplication);
            }
            featureApplication.addProgramClass(clazz);
        }
        return applications;
    }
}

