/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.cf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;

public class TypeVerificationHelper {
    private final IRCode code;
    private final DexItemFactory factory;
    private final AppInfoWithSubtyping appInfo;
    private Map<Value, DexType> types;

    public TypeVerificationHelper(IRCode code, DexItemFactory factory, AppInfoWithSubtyping appInfo) {
        this.code = code;
        this.factory = factory;
        this.appInfo = appInfo;
    }

    public DexItemFactory getFactory() {
        return this.factory;
    }

    public DexType getType(Value value) {
        assert (value.outType().isObject());
        return this.types.get(value);
    }

    public DexType join(Set<DexType> types) {
        assert (!types.isEmpty());
        if (types.size() == 1) {
            return types.iterator().next();
        }
        Iterator<DexType> iterator = types.iterator();
        TypeLatticeElement join = this.getLatticeElement(iterator.next());
        while (iterator.hasNext()) {
            join = TypeLatticeElement.join(this.appInfo, join, this.getLatticeElement(iterator.next()));
        }
        if (join.isClassTypeLatticeElement()) {
            return join.asClassTypeLatticeElement().getClassType();
        }
        if (join.isArrayTypeLatticeElement()) {
            return join.asArrayTypeLatticeElement().getArrayType();
        }
        throw new CompilationError("Unexpected join " + join + " of types: " + String.join((CharSequence)", ", types.stream().map(DexType::toSourceString).collect(Collectors.toList())));
    }

    private TypeLatticeElement getLatticeElement(DexType type) {
        return TypeLatticeElement.fromDexType(type, true);
    }

    public Map<Value, DexType> computeVerificationTypes() {
        int argumentIndex;
        this.types = new HashMap<Value, DexType>();
        HashSet<Value> worklist = new HashSet<Value>();
        InstructionIterator it = this.code.instructionIterator();
        Instruction instruction = null;
        int n = argumentIndex = this.code.method.accessFlags.isStatic() ? 0 : -1;
        while (it.hasNext() && (instruction = (Instruction)it.next()).isArgument()) {
            DexType argumentType = argumentIndex < 0 ? this.code.method.method.getHolder() : this.code.method.method.proto.parameters.values[argumentIndex];
            Value outValue = instruction.outValue();
            if (outValue.outType().isObject()) {
                this.types.put(outValue, argumentType);
                TypeVerificationHelper.addUsers(outValue, worklist);
            }
            ++argumentIndex;
        }
        while (instruction != null) {
            assert (!instruction.isArgument());
            if (instruction.outValue() != null && instruction.outType().isObject()) {
                Value outValue = instruction.outValue();
                if (instruction.hasInvariantVerificationType()) {
                    DexType type = instruction.computeVerificationType(this);
                    assert (type != null);
                    this.types.put(outValue, type);
                    TypeVerificationHelper.addUsers(outValue, worklist);
                }
            }
            instruction = it.hasNext() ? (Instruction)it.next() : null;
        }
        while (!worklist.isEmpty()) {
            DexType refinedType;
            Value item = (Value)worklist.iterator().next();
            worklist.remove(item);
            assert (item.outType().isObject());
            DexType previousType = this.types.get(item);
            if (previousType == (refinedType = this.computeVerificationType(item))) continue;
            this.types.put(item, refinedType);
            TypeVerificationHelper.addUsers(item, worklist);
        }
        return this.types;
    }

    private DexType computeVerificationType(Value value) {
        return value.isPhi() ? value.asPhi().computeVerificationType(this) : value.definition.computeVerificationType(this);
    }

    private static void addUsers(Value value, Set<Value> worklist) {
        worklist.addAll(value.uniquePhiUsers());
        for (Instruction instruction : value.uniqueUsers()) {
            if (instruction.outValue() == null || !instruction.outType().isObject() || instruction.hasInvariantVerificationType()) continue;
            worklist.add(instruction.outValue());
        }
    }
}

