/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.dex;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.dex.VDexReader;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;

public class VDexParser {
    private VDexReader vDexReader;
    private List<byte[]> dexFiles = new ArrayList<byte[]>();

    public void close() {
        this.vDexReader = null;
        this.dexFiles = ImmutableList.of();
    }

    public VDexParser(VDexReader vDexReader) {
        this.vDexReader = vDexReader;
        vDexReader.setByteOrder();
        this.parseDexFiles();
    }

    public List<byte[]> getDexFiles() {
        return this.dexFiles;
    }

    private void parseDexFiles() {
        this.vDexReader.position(8);
        int numberOfDexFiles = this.vDexReader.getUint();
        int dexSize = this.vDexReader.getUint();
        int verifierDepsSize = this.vDexReader.getUint();
        int quickeningInfoSize = this.vDexReader.getUint();
        int offset = VDexReader.firstDexOffset(numberOfDexFiles);
        int totalDexSize = 0;
        for (int i = 0; i < numberOfDexFiles; ++i) {
            int size = this.vDexReader.getUint(offset + 32);
            this.vDexReader.position(offset);
            this.dexFiles.add(this.vDexReader.getByteArray(size));
            totalDexSize += size;
            offset += size;
        }
        if (totalDexSize != dexSize) {
            throw new CompilationError("Invalid vdex file. Mismatch in total dex files size");
        }
    }
}

