/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import shadow.bundletool.com.android.tools.r8.ApiLevelException;
import shadow.bundletool.com.android.tools.r8.errors.InvalidDebugInfoException;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.JarApplicationReader;
import shadow.bundletool.com.android.tools.r8.graph.JarClassFileReader;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueNumberGenerator;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.JarSourceCode;
import shadow.bundletool.com.android.tools.r8.jar.JarRegisterEffectsVisitor;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class JarCode
extends Code {
    private final DexMethod method;
    private final Origin origin;
    private MethodNode node;
    private ReparseContext context;
    private final JarApplicationReader application;

    public void writeTo(MethodVisitor visitor) {
        this.node.accept(visitor);
    }

    public JarCode(DexMethod method, Origin origin, ReparseContext context, JarApplicationReader application) {
        this.method = method;
        this.origin = origin;
        this.context = context;
        this.application = application;
        context.codeList.add(this);
    }

    @Override
    public boolean isJarCode() {
        return true;
    }

    @Override
    public JarCode asJarCode() {
        return this;
    }

    @Override
    protected int computeHashCode() {
        this.triggerDelayedParsingIfNeccessary();
        return this.node.hashCode();
    }

    @Override
    protected boolean computeEquals(Object other) {
        this.triggerDelayedParsingIfNeccessary();
        if (this == other) {
            return true;
        }
        if (other instanceof JarCode) {
            JarCode o = (JarCode)other;
            o.triggerDelayedParsingIfNeccessary();
            return this.node.equals(o.node);
        }
        return false;
    }

    @Override
    public IRCode buildIR(DexEncodedMethod encodedMethod, InternalOptions options) throws ApiLevelException {
        this.triggerDelayedParsingIfNeccessary();
        return options.debug ? this.internalBuildWithLocals(encodedMethod, options, null, null) : this.internalBuild(encodedMethod, options, null, null);
    }

    @Override
    public IRCode buildInliningIR(DexEncodedMethod encodedMethod, InternalOptions options, ValueNumberGenerator generator, Position callerPosition) throws ApiLevelException {
        assert (generator != null);
        this.triggerDelayedParsingIfNeccessary();
        return options.debug ? this.internalBuildWithLocals(encodedMethod, options, generator, callerPosition) : this.internalBuild(encodedMethod, options, generator, callerPosition);
    }

    private IRCode internalBuildWithLocals(DexEncodedMethod encodedMethod, InternalOptions options, ValueNumberGenerator generator, Position callerPosition) throws ApiLevelException {
        try {
            return this.internalBuild(encodedMethod, options, generator, callerPosition);
        }
        catch (InvalidDebugInfoException e) {
            options.warningInvalidDebugInfo(encodedMethod, this.origin, e);
            this.node.localVariables.clear();
            return this.internalBuild(encodedMethod, options, generator, callerPosition);
        }
    }

    private IRCode internalBuild(DexEncodedMethod encodedMethod, InternalOptions options, ValueNumberGenerator generator, Position callerPosition) throws ApiLevelException {
        if (!options.debug) {
            this.node.localVariables.clear();
        }
        JarSourceCode source = new JarSourceCode(this.method.getHolder(), this.node, this.application, encodedMethod.method, callerPosition);
        IRBuilder builder = generator == null ? new IRBuilder(encodedMethod, source, options) : new IRBuilder(encodedMethod, source, options, generator);
        return builder.build();
    }

    @Override
    public void registerReachableDefinitions(UseRegistry registry) {
        this.triggerDelayedParsingIfNeccessary();
        this.node.instructions.accept((MethodVisitor)new JarRegisterEffectsVisitor(this.method.getHolder(), registry, this.application));
    }

    @Override
    public String toString() {
        this.triggerDelayedParsingIfNeccessary();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)new Textifier());
        this.node.accept((MethodVisitor)visitor);
        StringWriter writer = new StringWriter();
        visitor.p.print(new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public String toString(DexEncodedMethod method, ClassNameMapper naming) {
        return this.toString();
    }

    private void triggerDelayedParsingIfNeccessary() {
        if (this.context != null) {
            DexProgramClass owner = this.context.owner;
            new ClassReader(this.context.classCache).accept((ClassVisitor)new SecondVisitor(this.context, this.application), 4);
            assert (JarCode.verifyNoReparseContext(owner));
        }
    }

    private static boolean verifyNoReparseContext(DexProgramClass owner) {
        Code code;
        for (DexEncodedMethod method : owner.virtualMethods()) {
            code = method.getCode();
            if (code == null || !code.isJarCode() || code.asJarCode().context == null) continue;
            return false;
        }
        for (DexEncodedMethod method : owner.directMethods()) {
            code = method.getCode();
            if (code == null || !code.isJarCode() || code.asJarCode().context == null) continue;
            return false;
        }
        return true;
    }

    private static class SecondVisitor
    extends ClassVisitor {
        private final ReparseContext context;
        private final JarApplicationReader application;
        private int methodIndex = 0;

        public SecondVisitor(ReparseContext context, JarApplicationReader application) {
            super(393216);
            this.context = context;
            this.application = application;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            JSRInlinerAdapter node = new JSRInlinerAdapter(null, access, name, desc, signature, exceptions);
            JarCode code = null;
            MethodAccessFlags flags = JarClassFileReader.createMethodAccessFlags(name, access);
            if (!flags.isAbstract() && !flags.isNative()) {
                code = (JarCode)this.context.codeList.get(this.methodIndex++);
                assert (code.method == this.application.getMethod(this.context.owner.type, name, desc));
            }
            if (code != null) {
                code.context = null;
                code.node = (MethodNode)node;
                return node;
            }
            return null;
        }
    }

    public static class ReparseContext {
        public byte[] classCache;
        public DexProgramClass owner;
        private final List<JarCode> codeList = new ArrayList<JarCode>();
    }
}

