/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.List;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfMultiANewArray;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;

public class InvokeMultiNewArray
extends Invoke {
    private final DexType type;

    public InvokeMultiNewArray(DexType type, Value result, List<Value> arguments) {
        super(result, arguments);
        this.type = type;
    }

    @Override
    public boolean isInvokeMultiNewArray() {
        return true;
    }

    @Override
    public InvokeMultiNewArray asInvokeMultiNewArray() {
        return this;
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.MULTI_NEW_ARRAY;
    }

    public DexType getArrayType() {
        return this.type;
    }

    @Override
    public DexType getReturnType() {
        return this.getArrayType();
    }

    @Override
    protected String getTypeString() {
        return "MultiNewArray";
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isInvokeMultiNewArray()) {
            return false;
        }
        return this.type == other.asInvokeMultiNewArray().type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        if (!other.isInvokeMultiNewArray()) {
            return -1;
        }
        return this.type.slowCompareTo(other.asInvokeMultiNewArray().type);
    }

    @Override
    public Inliner.Constraint inliningConstraint(Enqueuer.AppInfoWithLiveness info, DexType invocationContext) {
        return Inliner.Constraint.classIsVisible(invocationContext, this.type, info);
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo, Function<Value, TypeLatticeElement> getLatticeElement) {
        return TypeLatticeElement.newArray(this.type, false);
    }

    @Override
    public boolean hasInvariantVerificationType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return this.type;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfMultiANewArray(this.type, this.arguments().size()));
    }

    @Override
    public void buildDex(DexBuilder builder) {
        throw new Unreachable("InvokeNewArray (non-empty) not supported when compiling to dex files.");
    }
}

