/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfMonitor;
import shadow.bundletool.com.android.tools.r8.code.MonitorEnter;
import shadow.bundletool.com.android.tools.r8.code.MonitorExit;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;

public class Monitor
extends Instruction {
    private final Type type;

    public Monitor(Type type, Value object) {
        super(null, object);
        this.type = type;
    }

    public Value object() {
        return (Value)this.inValues.get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int object = builder.argumentOrAllocateRegister(this.object(), this.getNumber());
        if (object > this.maxInValueRegister()) {
            object = builder.allocatedRegister(this.object(), this.getNumber());
        }
        if (this.type == Type.ENTER) {
            builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)new MonitorEnter(object));
        } else {
            builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)new MonitorExit(object));
        }
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.asMonitor().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.ordinal() - other.asMonitor().type.ordinal();
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "Monitor defines no values.";
        return 0;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isMonitor() {
        return true;
    }

    @Override
    public Monitor asMonitor() {
        return this;
    }

    @Override
    public Inliner.Constraint inliningConstraint(Enqueuer.AppInfoWithLiveness info, DexType invocationContext) {
        return Inliner.Constraint.NEVER;
    }

    @Override
    public String getInstructionName() {
        switch (this.type) {
            case ENTER: {
                return "MonitorEnter";
            }
            case EXIT: {
                return "MonitorExit";
            }
        }
        throw new Unreachable("Unknown monitor type:" + (Object)((Object)this.type));
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfMonitor(this.type));
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value) {
        return this.object() == value;
    }

    public static enum Type {
        ENTER,
        EXIT;

    }
}

