/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ClassesDexNameSanitizer;
import com.android.tools.build.bundletool.model.ModuleAbiSanitizer;
import com.android.tools.build.bundletool.model.ModuleZipEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.utils.ZipUtils;
import com.android.tools.build.bundletool.utils.files.BufferedIo;
import com.android.tools.build.bundletool.version.BundleToolVersion;
import com.android.tools.build.bundletool.version.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.CheckReturnValue;

public class AppBundle {
    public static final ZipPath METADATA_DIRECTORY = ZipPath.create("BUNDLE-METADATA");
    public static final String BUNDLE_CONFIG_FILE_NAME = "BundleConfig.pb";
    private final ImmutableMap<BundleModuleName, BundleModule> modules;
    private final Config.BundleConfig bundleConfig;
    private final BundleMetadata bundleMetadata;

    private AppBundle(ImmutableMap<BundleModuleName, BundleModule> modules, Config.BundleConfig bundleConfig, BundleMetadata bundleMetadata) {
        this.modules = modules;
        this.bundleConfig = bundleConfig;
        this.bundleMetadata = bundleMetadata;
    }

    public static AppBundle buildFromZip(ZipFile bundleFile) {
        Config.BundleConfig bundleConfig = AppBundle.readBundleConfig(bundleFile);
        return new AppBundle(AppBundle.sanitize(AppBundle.extractModules(bundleFile), bundleConfig), bundleConfig, AppBundle.readBundleMetadata(bundleFile));
    }

    public static AppBundle buildFromModules(ImmutableCollection<BundleModule> modules, Config.BundleConfig bundleConfig, BundleMetadata bundleMetadata) {
        return new AppBundle((ImmutableMap<BundleModuleName, BundleModule>)Maps.uniqueIndex(modules, BundleModule::getName), bundleConfig, bundleMetadata);
    }

    public ImmutableMap<BundleModuleName, BundleModule> getModules() {
        return this.modules;
    }

    public BundleModule getBaseModule() {
        return this.getModule(BundleModuleName.create("base"));
    }

    public BundleModule getModule(BundleModuleName moduleName) {
        BundleModule module = (BundleModule)this.modules.get((Object)moduleName);
        if (module == null) {
            throw CommandExecutionException.builder().withMessage("Module '%s' not found.", moduleName).build();
        }
        return module;
    }

    public Config.BundleConfig getBundleConfig() {
        return this.bundleConfig;
    }

    public BundleMetadata getBundleMetadata() {
        return this.bundleMetadata;
    }

    private static Map<BundleModuleName, BundleModule> extractModules(ZipFile bundleFile) {
        HashMap<BundleModuleName, BundleModule.Builder> moduleBuilders = new HashMap<BundleModuleName, BundleModule.Builder>();
        Enumeration<? extends ZipEntry> entries = bundleFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            ZipPath path = ZipPath.create(entry.getName());
            if (path.startsWith(METADATA_DIRECTORY) || path.startsWith("META-INF") || path.getNameCount() <= 1 || path.toString().endsWith(".class")) continue;
            BundleModuleName moduleName = BundleModuleName.create(path.getName(0).toString());
            BundleModule.Builder moduleBuilder = moduleBuilders.computeIfAbsent(moduleName, name -> BundleModule.builder().setName((BundleModuleName)name));
            try {
                moduleBuilder.addEntry(ModuleZipEntry.fromBundleZipEntry(entry, bundleFile));
            }
            catch (IOException e) {
                throw ValidationException.builder().withCause(e).withMessage("Error processing zip entry '%s' of module '%s'.", entry.getName(), moduleName).build();
            }
        }
        return Maps.transformValues(moduleBuilders, BundleModule.Builder::build);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Config.BundleConfig readBundleConfig(ZipFile bundleFile) {
        ZipEntry bundleConfigEntry = bundleFile.getEntry(BUNDLE_CONFIG_FILE_NAME);
        Preconditions.checkState((bundleConfigEntry != null ? 1 : 0) != 0, (String)"File '%s' was not found.", (Object)BUNDLE_CONFIG_FILE_NAME);
        try (InputStream is = BufferedIo.inputStream(bundleFile, bundleConfigEntry);){
            Config.BundleConfig bundleConfig = Config.BundleConfig.parseFrom(is);
            return bundleConfig;
        }
        catch (InvalidProtocolBufferException e) {
            throw ValidationException.builder().withCause(e).withMessage("Bundle config '%s' could not be parsed.", BUNDLE_CONFIG_FILE_NAME).build();
        }
        catch (IOException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("Error reading file '%s'.", BUNDLE_CONFIG_FILE_NAME).build();
        }
    }

    private static BundleMetadata readBundleMetadata(ZipFile bundleFile) {
        BundleMetadata.Builder metadata = BundleMetadata.builder();
        ZipUtils.getFileEntriesWithPathPrefix(bundleFile, METADATA_DIRECTORY).forEach(zipEntry -> {
            ZipPath bundlePath = ZipPath.create(zipEntry.getName());
            ZipPath metadataPath = bundlePath.subpath(1, bundlePath.getNameCount());
            metadata.addFile(metadataPath, () -> BufferedIo.inputStream(bundleFile, zipEntry));
        });
        return metadata.build();
    }

    @CheckReturnValue
    private static ImmutableMap<BundleModuleName, BundleModule> sanitize(Map<BundleModuleName, BundleModule> moduleMap, Config.BundleConfig bundleConfig) {
        Version bundleVersion = BundleToolVersion.getVersionFromBundleConfig(bundleConfig);
        if (bundleVersion.isOlderThan(Version.of("0.3.1"))) {
            moduleMap = Maps.transformValues(moduleMap, new ModuleAbiSanitizer()::sanitize);
        }
        moduleMap = Maps.transformValues(moduleMap, new ClassesDexNameSanitizer()::sanitize);
        return ImmutableMap.copyOf((Map)moduleMap);
    }
}

