/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.manifest.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

final class AutoValue_ModuleSplit
extends ModuleSplit {
    private final Targeting.ApkTargeting targeting;
    private final ImmutableList<ModuleEntry> entries;
    private final Optional<Resources.ResourceTable> resourceTable;
    private final Optional<AndroidManifest> androidManifest;
    private final BundleModuleName moduleName;
    private final boolean masterSplit;
    private final Optional<Files.NativeLibraries> nativeConfig;
    private final Optional<Files.Assets> assetsConfig;

    private AutoValue_ModuleSplit(Targeting.ApkTargeting targeting, ImmutableList<ModuleEntry> entries, Optional<Resources.ResourceTable> resourceTable, Optional<AndroidManifest> androidManifest, BundleModuleName moduleName, boolean masterSplit, Optional<Files.NativeLibraries> nativeConfig, Optional<Files.Assets> assetsConfig) {
        this.targeting = targeting;
        this.entries = entries;
        this.resourceTable = resourceTable;
        this.androidManifest = androidManifest;
        this.moduleName = moduleName;
        this.masterSplit = masterSplit;
        this.nativeConfig = nativeConfig;
        this.assetsConfig = assetsConfig;
    }

    @Override
    public Targeting.ApkTargeting getTargeting() {
        return this.targeting;
    }

    @Override
    public ImmutableList<ModuleEntry> getEntries() {
        return this.entries;
    }

    @Override
    public Optional<Resources.ResourceTable> getResourceTable() {
        return this.resourceTable;
    }

    @Override
    public Optional<AndroidManifest> getAndroidManifest() {
        return this.androidManifest;
    }

    @Override
    public BundleModuleName getModuleName() {
        return this.moduleName;
    }

    @Override
    public boolean isMasterSplit() {
        return this.masterSplit;
    }

    @Override
    public Optional<Files.NativeLibraries> getNativeConfig() {
        return this.nativeConfig;
    }

    @Override
    public Optional<Files.Assets> getAssetsConfig() {
        return this.assetsConfig;
    }

    public String toString() {
        return "ModuleSplit{targeting=" + this.targeting + ", entries=" + this.entries + ", resourceTable=" + this.resourceTable + ", androidManifest=" + this.androidManifest + ", moduleName=" + this.moduleName + ", masterSplit=" + this.masterSplit + ", nativeConfig=" + this.nativeConfig + ", assetsConfig=" + this.assetsConfig + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ModuleSplit) {
            ModuleSplit that = (ModuleSplit)o;
            return this.targeting.equals(that.getTargeting()) && this.entries.equals(that.getEntries()) && this.resourceTable.equals(that.getResourceTable()) && this.androidManifest.equals(that.getAndroidManifest()) && this.moduleName.equals(that.getModuleName()) && this.masterSplit == that.isMasterSplit() && this.nativeConfig.equals(that.getNativeConfig()) && this.assetsConfig.equals(that.getAssetsConfig());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.targeting.hashCode();
        h *= 1000003;
        h ^= this.entries.hashCode();
        h *= 1000003;
        h ^= this.resourceTable.hashCode();
        h *= 1000003;
        h ^= this.androidManifest.hashCode();
        h *= 1000003;
        h ^= this.moduleName.hashCode();
        h *= 1000003;
        h ^= this.masterSplit ? 1231 : 1237;
        h *= 1000003;
        h ^= this.nativeConfig.hashCode();
        h *= 1000003;
        return h ^= this.assetsConfig.hashCode();
    }

    @Override
    public ModuleSplit.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ModuleSplit.Builder {
        private Targeting.ApkTargeting targeting;
        private ImmutableList<ModuleEntry> entries;
        private Optional<Resources.ResourceTable> resourceTable = Optional.empty();
        private Optional<AndroidManifest> androidManifest = Optional.empty();
        private BundleModuleName moduleName;
        private Boolean masterSplit;
        private Optional<Files.NativeLibraries> nativeConfig = Optional.empty();
        private Optional<Files.Assets> assetsConfig = Optional.empty();

        Builder() {
        }

        private Builder(ModuleSplit source) {
            this.targeting = source.getTargeting();
            this.entries = source.getEntries();
            this.resourceTable = source.getResourceTable();
            this.androidManifest = source.getAndroidManifest();
            this.moduleName = source.getModuleName();
            this.masterSplit = source.isMasterSplit();
            this.nativeConfig = source.getNativeConfig();
            this.assetsConfig = source.getAssetsConfig();
        }

        @Override
        public ModuleSplit.Builder setTargeting(Targeting.ApkTargeting targeting) {
            if (targeting == null) {
                throw new NullPointerException("Null targeting");
            }
            this.targeting = targeting;
            return this;
        }

        @Override
        public ModuleSplit.Builder setEntries(List<ModuleEntry> entries) {
            if (entries == null) {
                throw new NullPointerException("Null entries");
            }
            this.entries = ImmutableList.copyOf(entries);
            return this;
        }

        @Override
        public ModuleSplit.Builder setResourceTable(Resources.ResourceTable resourceTable) {
            if (resourceTable == null) {
                throw new NullPointerException("Null resourceTable");
            }
            this.resourceTable = Optional.of(resourceTable);
            return this;
        }

        @Override
        public ModuleSplit.Builder setAndroidManifest(AndroidManifest androidManifest) {
            if (androidManifest == null) {
                throw new NullPointerException("Null androidManifest");
            }
            this.androidManifest = Optional.of(androidManifest);
            return this;
        }

        @Override
        public ModuleSplit.Builder setModuleName(BundleModuleName moduleName) {
            if (moduleName == null) {
                throw new NullPointerException("Null moduleName");
            }
            this.moduleName = moduleName;
            return this;
        }

        @Override
        public ModuleSplit.Builder setMasterSplit(boolean masterSplit) {
            this.masterSplit = masterSplit;
            return this;
        }

        @Override
        public ModuleSplit.Builder setNativeConfig(Files.NativeLibraries nativeConfig) {
            if (nativeConfig == null) {
                throw new NullPointerException("Null nativeConfig");
            }
            this.nativeConfig = Optional.of(nativeConfig);
            return this;
        }

        @Override
        public ModuleSplit.Builder setAssetsConfig(Files.Assets assetsConfig) {
            if (assetsConfig == null) {
                throw new NullPointerException("Null assetsConfig");
            }
            this.assetsConfig = Optional.of(assetsConfig);
            return this;
        }

        @Override
        protected ModuleSplit autoBuild() {
            String missing = "";
            if (this.targeting == null) {
                missing = missing + " targeting";
            }
            if (this.entries == null) {
                missing = missing + " entries";
            }
            if (this.moduleName == null) {
                missing = missing + " moduleName";
            }
            if (this.masterSplit == null) {
                missing = missing + " masterSplit";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ModuleSplit(this.targeting, this.entries, this.resourceTable, this.androidManifest, this.moduleName, this.masterSplit, this.nativeConfig, this.assetsConfig);
        }
    }
}

