/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.bundle.Commands;
import com.android.bundle.Files;
import com.android.tools.build.bundletool.manifest.AndroidManifest;
import com.android.tools.build.bundletool.model.AutoValue_BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

@AutoValue
public abstract class BundleModule {
    public static final String MANIFEST_FILENAME = "AndroidManifest.xml";
    public static final ZipPath ASSETS_DIRECTORY = ZipPath.create("assets");
    public static final ZipPath DEX_DIRECTORY = ZipPath.create("dex");
    public static final ZipPath LIB_DIRECTORY = ZipPath.create("lib");
    public static final ZipPath MANIFEST_DIRECTORY = ZipPath.create("manifest");
    public static final ZipPath RESOURCES_DIRECTORY = ZipPath.create("res");
    public static final ZipPath ROOT_DIRECTORY = ZipPath.create("root");
    public static final ZipPath ASSETS_PROTO_PATH = ZipPath.create("assets.pb");
    public static final ZipPath MANIFEST_PATH = MANIFEST_DIRECTORY.resolve("AndroidManifest.xml");
    public static final ZipPath NATIVE_PROTO_PATH = ZipPath.create("native.pb");
    public static final ZipPath RESOURCES_PROTO_PATH = ZipPath.create("resources.pb");

    public abstract BundleModuleName getName();

    public abstract AndroidManifest getAndroidManifest();

    public abstract Optional<Resources.ResourceTable> getResourceTable();

    public abstract Optional<Files.Assets> getAssetsConfig();

    public abstract Optional<Files.NativeLibraries> getNativeConfig();

    abstract ImmutableMap<ZipPath, ModuleEntry> getEntryMap();

    public ImmutableCollection<ModuleEntry> getEntries() {
        return this.getEntryMap().values();
    }

    public boolean isBaseModule() {
        return "base".equals(this.getName().getName());
    }

    public boolean isIncludedInFusing() {
        return this.isBaseModule() || this.getAndroidManifest().getIsModuleIncludedInFusing().get() != false;
    }

    public Stream<ModuleEntry> findEntries(Predicate<ZipPath> pathPredicate) {
        return this.getEntries().stream().filter(entry -> pathPredicate.test(entry.getPath()));
    }

    public Stream<ModuleEntry> findEntriesUnderPath(ZipPath path) {
        return this.findEntries(p -> p.startsWith(path));
    }

    public Optional<ModuleEntry> getEntry(ZipPath path) {
        return Optional.ofNullable(this.getEntryMap().get((Object)path));
    }

    public Commands.ModuleMetadata getModuleMetadata() {
        return Commands.ModuleMetadata.newBuilder().setName(this.getName().getName()).setOnDemand(this.getAndroidManifest().isDynamicModule()).build();
    }

    public static Builder builder() {
        return new AutoValue_BundleModule.Builder();
    }

    abstract Builder toBuilder();

    public static abstract class Builder {
        public abstract Builder setName(BundleModuleName var1);

        abstract ImmutableMap.Builder<ZipPath, ModuleEntry> entryMapBuilder();

        abstract Builder setEntryMap(ImmutableMap<ZipPath, ModuleEntry> var1);

        abstract Builder setAndroidManifest(AndroidManifest var1);

        abstract Builder setResourceTable(Resources.ResourceTable var1);

        abstract Builder setAssetsConfig(Files.Assets var1);

        abstract Builder setNativeConfig(Files.NativeLibraries var1);

        public Builder addEntries(Collection<ModuleEntry> entries) throws IOException {
            for (ModuleEntry entry : entries) {
                this.addEntry(entry);
            }
            return this;
        }

        public Builder addEntry(ModuleEntry moduleEntry) throws IOException {
            if (moduleEntry.getPath().equals(MANIFEST_PATH)) {
                try (InputStream inputStream = moduleEntry.getContent();){
                    this.setAndroidManifest(AndroidManifest.create(Resources.XmlNode.parseFrom((InputStream)inputStream)));
                }
            } else if (moduleEntry.getPath().equals(RESOURCES_PROTO_PATH)) {
                try (InputStream inputStream = moduleEntry.getContent();){
                    this.setResourceTable(Resources.ResourceTable.parseFrom((InputStream)inputStream));
                }
            } else if (moduleEntry.getPath().equals(ASSETS_PROTO_PATH)) {
                try (InputStream inputStream = moduleEntry.getContent();){
                    this.setAssetsConfig(Files.Assets.parseFrom(inputStream));
                }
            } else if (moduleEntry.getPath().equals(NATIVE_PROTO_PATH)) {
                try (InputStream inputStream = moduleEntry.getContent();){
                    this.setNativeConfig(Files.NativeLibraries.parseFrom(inputStream));
                }
            } else if (!moduleEntry.isDirectory()) {
                this.entryMapBuilder().put((Object)moduleEntry.getPath(), (Object)moduleEntry);
            }
            return this;
        }

        public abstract BundleModule build();
    }
}

