/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.util.Map;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.naming.MemberNameMinifier;
import shadow.bundletool.com.android.tools.r8.naming.NamingState;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfiguration;
import shadow.bundletool.com.android.tools.r8.shaking.RootSetBuilder;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

class FieldNameMinifier
extends MemberNameMinifier<DexField, DexType> {
    FieldNameMinifier(AppInfoWithSubtyping appInfo, RootSetBuilder.RootSet rootSet, InternalOptions options) {
        super(appInfo, rootSet, options);
    }

    @Override
    Function<DexType, ?> getKeyTransform(ProguardConfiguration config) {
        if (config.isOverloadAggressively()) {
            return a -> a;
        }
        return a -> Void.class;
    }

    Map<DexField, DexString> computeRenaming(Timing timing) {
        timing.begin("reserve-classes");
        this.reserveNamesInSubtypes(this.appInfo.dexItemFactory.objectType, this.globalState);
        timing.end();
        timing.begin("reserve-interfaces");
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, iface -> this.reserveNamesInSubtypes((DexType)iface, this.globalState));
        timing.end();
        timing.begin("rename");
        this.renameFieldsInSubtypes(this.appInfo.dexItemFactory.objectType);
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, this::renameFieldsInSubtypes);
        timing.end();
        return this.renaming;
    }

    private void reserveNamesInSubtypes(DexType type, NamingState<DexType, ?> state) {
        DexClass holder = this.appInfo.definitionFor(type);
        if (holder == null) {
            return;
        }
        NamingState newState = this.computeStateIfAbsent(type, t -> state.createChild());
        holder.forEachField(field -> this.reserveFieldName((DexEncodedField)field, newState, holder.isLibraryClass()));
        type.forAllExtendsSubtypes(subtype -> this.reserveNamesInSubtypes((DexType)subtype, newState));
    }

    private void reserveFieldName(DexEncodedField encodedField, NamingState<DexType, ?> state, boolean isLibrary) {
        if (isLibrary || this.rootSet.noObfuscation.contains(encodedField)) {
            DexField field = encodedField.field;
            state.reserveName(field.name, field.type);
        }
    }

    private void renameFieldsInSubtypes(DexType type) {
        DexClass clazz = this.appInfo.definitionFor(type);
        if (clazz == null) {
            return;
        }
        NamingState state = this.getState(clazz.type);
        assert (state != null);
        clazz.forEachField(field -> this.renameField((DexEncodedField)field, state));
        type.forAllExtendsSubtypes(this::renameFieldsInSubtypes);
    }

    private void renameField(DexEncodedField encodedField, NamingState<DexType, ?> state) {
        DexField field = encodedField.field;
        if (!state.isReserved(field.name, field.type)) {
            DexString candidate = state.assignNewNameFor(field.name, field.type, false);
            this.renaming.put(field, candidate);
            state.addRenaming(field.name, field.type, candidate);
        }
    }
}

