/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.util.Stack;

public class Timing {
    private final Stack<Node> stack = new Stack();

    public Timing(String title) {
        this.stack.push(new Node("Recorded timings for " + title));
    }

    public void begin(String title) {
        Node n = new Node(title);
        this.stack.peek().sons.add(n);
        this.stack.push(n);
    }

    public void end() {
        this.stack.peek().end();
        this.stack.pop();
    }

    public void report() {
        Node top = this.stack.peek();
        top.end();
        System.out.println();
        top.report(0, top);
    }

    public void scope(String title, TimingScope fn) {
        this.begin(title);
        try {
            fn.apply();
        }
        finally {
            this.end();
        }
    }

    public static interface TimingScope {
        public void apply();
    }

    static class Node {
        final String title;
        final Stack<Node> sons = new Stack();
        final long start_time;
        long stop_time;

        Node(String title) {
            this.title = title;
            this.start_time = System.nanoTime();
            this.stop_time = -1L;
        }

        void end() {
            this.stop_time = System.nanoTime();
            assert (this.duration() >= 0L);
        }

        long duration() {
            return this.stop_time - this.start_time;
        }

        public String toString() {
            return this.title + ": " + this.duration() / 1000000L + "ms.";
        }

        public String toString(Node top) {
            if (this == top) {
                return this.toString();
            }
            long percentage = this.duration() * 100L / top.duration();
            return this.toString() + " (" + percentage + "%)";
        }

        public void report(int depth, Node top) {
            assert (this.duration() >= 0L);
            if (depth > 0) {
                for (int i = 0; i < depth; ++i) {
                    System.out.print("  ");
                }
                System.out.print("- ");
            }
            System.out.println(this.toString(top));
            this.sons.forEach(p -> p.report(depth + 1, top));
        }
    }
}

