/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Devices;
import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import shadow.bundletool.com.android.ddmlib.IDevice;

public class DeviceAnalyzer {
    private final AdbServer adb;
    private static final String LOCALE_PROPERTY_SYS = "persist.sys.locale";
    private static final String LOCALE_PROPERTY_PRODUCT = "ro.product.locale";
    private static final String LEGACY_LANGUAGE_PROPERTY = "ro.product.locale.language";
    private static final String LEGACY_REGION_PROPERTY = "ro.product.locale.region";

    public DeviceAnalyzer(AdbServer adb) {
        this.adb = adb;
    }

    public Devices.DeviceSpec getDeviceSpec(Optional<String> deviceId) {
        try {
            Device device = this.getAndValidateDevice(deviceId);
            return Devices.DeviceSpec.newBuilder().setSdkVersion(device.getVersion().getApiLevel()).addAllSupportedAbis((Iterable<String>)device.getAbis()).addSupportedLocales(this.getMainLocale(device)).setScreenDensity(device.getDensity()).build();
        }
        catch (TimeoutException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("Timed out while waiting for ADB.").build();
        }
    }

    private String getMainLocale(Device device) {
        Optional<Object> locale = Optional.empty();
        int apiLevel = device.getVersion().getApiLevel();
        if (apiLevel < 23) {
            Optional<String> language = device.getProperty(LEGACY_LANGUAGE_PROPERTY);
            Optional<String> region = device.getProperty(LEGACY_REGION_PROPERTY);
            if (language.isPresent() && region.isPresent()) {
                locale = Optional.of(language.get() + "-" + region.get());
            }
        } else {
            locale = device.getProperty(LOCALE_PROPERTY_SYS);
            if (!locale.isPresent()) {
                locale = device.getProperty(LOCALE_PROPERTY_PRODUCT);
            }
        }
        return locale.orElseGet(() -> {
            System.err.println("Warning: Can't detect device locale, will use 'en-US'.");
            return "en-US";
        });
    }

    private Device getAndValidateDevice(Optional<String> deviceId) throws TimeoutException {
        Device device = this.getTargetDevice(deviceId).orElseThrow(() -> CommandExecutionException.builder().withMessage("Unable to find the requested device.").build());
        if (device.getState() == IDevice.DeviceState.UNAUTHORIZED) {
            throw CommandExecutionException.builder().withMessage("Device found but not authorized for connecting. Please allow USB debugging on the device.").build();
        }
        if (device.getState() != IDevice.DeviceState.ONLINE) {
            throw CommandExecutionException.builder().withMessage("Unable to connect to the device (device state: '%s').", device.getState().name()).build();
        }
        return device;
    }

    private Optional<Device> getTargetDevice(Optional<String> deviceId) throws TimeoutException {
        ImmutableList<Device> devices = this.adb.getDevices();
        if (devices.isEmpty()) {
            throw new CommandExecutionException("No connected devices found.");
        }
        if (deviceId.isPresent()) {
            return devices.stream().filter(device -> device.getSerialNumber().equals(deviceId.get())).findFirst();
        }
        if (devices.size() > 1) {
            throw new CommandExecutionException("More than one device connected, please provide --device-id.");
        }
        return Optional.of(devices.get(0));
    }
}

