/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.validation.AbiParityValidator;
import com.android.tools.build.bundletool.validation.AndroidManifestValidator;
import com.android.tools.build.bundletool.validation.AssetsTargetingValidator;
import com.android.tools.build.bundletool.validation.BundleConfigValidator;
import com.android.tools.build.bundletool.validation.BundleFilesValidator;
import com.android.tools.build.bundletool.validation.BundleZipValidator;
import com.android.tools.build.bundletool.validation.DexFilesValidator;
import com.android.tools.build.bundletool.validation.EntryClashValidator;
import com.android.tools.build.bundletool.validation.MandatoryFilesPresenceValidator;
import com.android.tools.build.bundletool.validation.ModuleDependencyValidator;
import com.android.tools.build.bundletool.validation.NativeTargetingValidator;
import com.android.tools.build.bundletool.validation.ResourceTableValidator;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.android.tools.build.bundletool.validation.ValidatorRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.zip.ZipFile;

public class AppBundleValidator {
    @VisibleForTesting
    static final ImmutableList<SubValidator> BUNDLE_FILE_SUB_VALIDATORS = ImmutableList.of((Object)new BundleZipValidator(), (Object)new MandatoryFilesPresenceValidator());
    @VisibleForTesting
    static final ImmutableList<SubValidator> BUNDLE_SUB_VALIDATORS = ImmutableList.of((Object)new BundleFilesValidator(), (Object)new AndroidManifestValidator(), (Object)new BundleConfigValidator(), (Object)new EntryClashValidator(), (Object)new AbiParityValidator(), (Object)new DexFilesValidator(), (Object)new AssetsTargetingValidator(), (Object)new NativeTargetingValidator(), (Object)new ModuleDependencyValidator(), (Object)new ResourceTableValidator());

    public void validateFile(ZipFile bundleFile) {
        new ValidatorRunner(BUNDLE_FILE_SUB_VALIDATORS).validateBundleZipFile(bundleFile);
    }

    public void validate(AppBundle bundle) {
        new ValidatorRunner(BUNDLE_SUB_VALIDATORS).validateBundle(bundle);
    }
}

