/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.IdentityHashMap;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.ApiLevelException;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class EnumOrdinalMapCollector {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final InternalOptions options;
    private final Map<DexType, Reference2IntMap<DexField>> ordinalsMaps = new IdentityHashMap<DexType, Reference2IntMap<DexField>>();

    public EnumOrdinalMapCollector(Enqueuer.AppInfoWithLiveness appInfo, InternalOptions options) {
        this.appInfo = appInfo;
        this.options = options;
    }

    public Enqueuer.AppInfoWithLiveness run() throws ApiLevelException {
        for (DexProgramClass clazz : this.appInfo.classes()) {
            this.processClasses(clazz);
        }
        if (!this.ordinalsMaps.isEmpty()) {
            return this.appInfo.addEnumOrdinalMaps(this.ordinalsMaps);
        }
        return this.appInfo;
    }

    private void processClasses(DexProgramClass clazz) throws ApiLevelException {
        if (!clazz.accessFlags.isEnum() || clazz.isLibraryClass() || !clazz.hasClassInitializer()) {
            return;
        }
        DexEncodedMethod initializer = clazz.getClassInitializer();
        IRCode code = initializer.getCode().buildIR(initializer, this.options);
        Reference2IntArrayMap ordinalsMap = new Reference2IntArrayMap();
        ordinalsMap.defaultReturnValue(-1);
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            Instruction newInstance;
            Instruction insn = (Instruction)it.next();
            if (!insn.isStaticPut()) continue;
            StaticPut staticPut = insn.asStaticPut();
            if (staticPut.getField().type != clazz.type || (newInstance = staticPut.inValue().definition) == null || !newInstance.isNewInstance()) continue;
            Instruction ordinal = null;
            for (Instruction ctorCall : newInstance.outValue().uniqueUsers()) {
                InvokeDirect invoke;
                if (!ctorCall.isInvokeDirect() || !this.appInfo.dexItemFactory.isConstructor((invoke = ctorCall.asInvokeDirect()).getInvokedMethod()) || invoke.arguments().size() < 3) continue;
                ordinal = invoke.arguments().get((int)2).definition;
                break;
            }
            if (ordinal == null || !ordinal.isConstNumber()) {
                return;
            }
            if (ordinalsMap.put((Object)staticPut.getField(), ordinal.asConstNumber().getIntValue()) == -1) continue;
            return;
        }
        this.ordinalsMaps.put(clazz.type, (Reference2IntMap<DexField>)ordinalsMap);
    }
}

