/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.io.ApkSetBuilderFactory;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.utils.ConcurrencyUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collection;
import java.util.stream.Stream;

public class ApkSerializerManager {
    private static final Commands.ModuleMetadata STANDALONE_MODULE_METADATA = Commands.ModuleMetadata.newBuilder().setName("base").build();
    private final ListeningExecutorService executorService;

    public ApkSerializerManager(ListeningExecutorService executorService) {
        this.executorService = executorService;
    }

    public ImmutableList<Commands.Variant> serializeAndGenerateAllVariants(ImmutableList<ModuleSplit> allApks, ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, AppBundle appBundle, boolean isUniversalApk) {
        ImmutableList splitApks = (ImmutableList)allApks.stream().filter(Predicates.not(ModuleSplit::isStandalone)).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((splitApks.isEmpty() || !isUniversalApk ? 1 : 0) != 0, (Object)"Internal error: for universal APK expecting only standalone APKs.");
        ImmutableList standaloneApks = (ImmutableList)allApks.stream().filter(ModuleSplit::isStandalone).collect(ImmutableList.toImmutableList());
        ImmutableList<Commands.Variant> standaloneVariants = this.serializeAndGenerateStandaloneApkVariants((ImmutableList<ModuleSplit>)standaloneApks, apkSetBuilder, isUniversalApk);
        ImmutableList<Commands.Variant> splitVariants = this.serializeAndGenerateSplitApkVariants((ImmutableList<ModuleSplit>)splitApks, apkSetBuilder, appBundle);
        return (ImmutableList)Stream.of(standaloneVariants, splitVariants).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    public Commands.Variant serializeAndGenerateVariantForDevice(Devices.DeviceSpec deviceSpec, ImmutableList<ModuleSplit> allApks, ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, AppBundle appBundle) {
        ImmutableList<Commands.Variant> variantList;
        ImmutableList<ModuleSplit> filteredApks = ApkSerializerManager.filterApksForDevice(allApks, deviceSpec);
        if (ApkSerializerManager.isAllStandalone(filteredApks)) {
            variantList = this.serializeAndGenerateStandaloneApkVariants(filteredApks, apkSetBuilder, false);
        } else if (ApkSerializerManager.isAllNotStandalone(filteredApks)) {
            variantList = this.serializeAndGenerateSplitApkVariants(filteredApks, apkSetBuilder, appBundle);
        } else {
            throw new IllegalStateException("Expected APKs to be either all split or standalone.");
        }
        Preconditions.checkState((variantList.size() == 1 ? 1 : 0) != 0);
        return (Commands.Variant)variantList.get(0);
    }

    private ImmutableList<Commands.Variant> serializeAndGenerateSplitApkVariants(ImmutableList<ModuleSplit> splitApks, ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, AppBundle appBundle) {
        ImmutableListMultimap targetingToSplits = Multimaps.index(splitApks, ModuleSplit::getVariantTargeting);
        ImmutableList.Builder variantsBuilder = ImmutableList.builder();
        for (Targeting.VariantTargeting variantTargeting : targetingToSplits.keySet()) {
            ImmutableListMultimap splitsByModule = Multimaps.index((Iterable)targetingToSplits.get((Object)variantTargeting), moduleSplit -> appBundle.getModule(moduleSplit.getModuleName()));
            Commands.Variant.Builder variantBuilder = Commands.Variant.newBuilder().setTargeting(variantTargeting);
            for (BundleModule module : splitsByModule.keySet()) {
                ImmutableList apkDescriptions = ConcurrencyUtils.waitForAll((Iterable)splitsByModule.get((Object)module).stream().map(splitApk -> this.executorService.submit(() -> apkSetBuilder.addSplitApk((ModuleSplit)splitApk))).collect(ImmutableList.toImmutableList()));
                variantBuilder.addApkSet(Commands.ApkSet.newBuilder().setModuleMetadata(module.getModuleMetadata()).addAllApkDescription((Iterable<? extends Commands.ApkDescription>)apkDescriptions).build());
            }
            variantsBuilder.add((Object)variantBuilder.build());
        }
        return variantsBuilder.build();
    }

    private ImmutableList<Commands.Variant> serializeAndGenerateStandaloneApkVariants(ImmutableList<ModuleSplit> standaloneApks, ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, boolean isUniversalApk) {
        return ConcurrencyUtils.waitForAll((Iterable)standaloneApks.stream().map(standaloneApk -> this.executorService.submit(() -> this.writeStandaloneApkVariant((ModuleSplit)standaloneApk, isUniversalApk, apkSetBuilder))).collect(ImmutableList.toImmutableList()));
    }

    private Commands.Variant writeStandaloneApkVariant(ModuleSplit standaloneApk, boolean isUniversalApk, ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder) {
        Commands.ApkDescription apkDescription = isUniversalApk ? apkSetBuilder.addStandaloneUniversalApk(standaloneApk) : apkSetBuilder.addStandaloneApk(standaloneApk);
        return Commands.Variant.newBuilder().setTargeting(standaloneApk.getVariantTargeting()).addApkSet(Commands.ApkSet.newBuilder().setModuleMetadata(STANDALONE_MODULE_METADATA).addApkDescription(apkDescription)).build();
    }

    private static ImmutableList<ModuleSplit> filterApksForDevice(ImmutableList<ModuleSplit> allApks, Devices.DeviceSpec deviceSpec) {
        ApkMatcher apkMatcher = new ApkMatcher(deviceSpec);
        return (ImmutableList)allApks.stream().filter(apkMatcher::matchesModuleSplit).collect(ImmutableList.toImmutableList());
    }

    private static boolean isAllStandalone(ImmutableList<ModuleSplit> moduleSplits) {
        return moduleSplits.stream().allMatch(ModuleSplit::isStandalone);
    }

    private static boolean isAllNotStandalone(ImmutableList<ModuleSplit> moduleSplits) {
        return moduleSplits.stream().noneMatch(ModuleSplit::isStandalone);
    }
}

