/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.manifest;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.exceptions.manifest.ManifestValidationException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ProtoXmlHelper {
    public static final String NO_NAMESPACE_URI = "";
    public static final String ANDROID_NAMESPACE_URI = "http://schemas.android.com/apk/res/android";
    public static final int NO_RESOURCE_ID = 0;

    public static Optional<Resources.XmlAttribute> findAttributeWithName(Resources.XmlElement el, String name) {
        return ProtoXmlHelper.findAttribute(el, NO_NAMESPACE_URI, name);
    }

    public static Optional<Resources.XmlAttribute> findAttributeWithResourceId(Resources.XmlElement el, int resourceId) {
        return el.getAttributeList().stream().filter(ProtoXmlHelper.attributeWithResourceId(resourceId)).findFirst();
    }

    public static Optional<Resources.XmlAttribute> findAttribute(Resources.XmlElement el, String namespaceUri, String name) {
        return el.getAttributeList().stream().filter(ProtoXmlHelper.attributeWithName(name).and(ProtoXmlHelper.attributeWithNamespaceUri(namespaceUri))).findFirst();
    }

    public static Optional<Resources.XmlAttribute> findAttributeIgnoringNamespace(Resources.XmlElement el, String name) {
        return el.getAttributeList().stream().filter(ProtoXmlHelper.attributeWithName(name)).findFirst();
    }

    public static boolean getAttributeValueAsBoolean(Resources.XmlAttribute attribute) {
        Resources.Primitive primitive = attribute.getCompiledItem().getPrim();
        if (primitive.getOneofValueCase() != Resources.Primitive.OneofValueCase.BOOLEAN_VALUE) {
            throw new ValidationException("Type of the compiled item is expected to be boolean, found:\n" + primitive);
        }
        return primitive.getBooleanValue();
    }

    public static Resources.XmlAttribute.Builder setAttributeValueAsBoolean(Resources.XmlAttribute.Builder attributeBuilder, boolean value) {
        attributeBuilder.clearValue();
        return attributeBuilder.setCompiledItem(Resources.Item.newBuilder().setPrim(Resources.Primitive.newBuilder().setBooleanValue(value)));
    }

    public static Integer getAttributeValueAsDecimalInteger(Resources.XmlAttribute attribute, Function<Resources.XmlAttribute, ManifestValidationException> wrongTypeHandler) {
        Resources.Primitive primitive = attribute.getCompiledItem().getPrim();
        if (primitive.getOneofValueCase() != Resources.Primitive.OneofValueCase.INT_DECIMAL_VALUE) {
            throw wrongTypeHandler.apply(attribute);
        }
        return primitive.getIntDecimalValue();
    }

    public static Resources.XmlAttribute.Builder setAttributeValueAsDecimalInteger(Resources.XmlAttribute.Builder attributeBuilder, int value) {
        attributeBuilder.setValue(String.valueOf(value));
        return attributeBuilder.setCompiledItem(Resources.Item.newBuilder().setPrim(Resources.Primitive.newBuilder().setIntDecimalValue(value)));
    }

    public static Resources.XmlAttribute.Builder findOrCreateAttributeBuilder(Resources.XmlElement.Builder el, String name) {
        return ProtoXmlHelper.findOrCreateAttributeBuilder(el, NO_NAMESPACE_URI, name);
    }

    public static Resources.XmlAttribute.Builder findOrCreateAttributeBuilder(Resources.XmlElement.Builder el, String namespaceUri, String name) {
        return el.getAttributeBuilderList().stream().filter(ProtoXmlHelper.attributeWithName(name).and(ProtoXmlHelper.attributeWithNamespaceUri(namespaceUri))).findFirst().orElseGet(() -> {
            el.addAttribute(Resources.XmlAttribute.newBuilder().setName(name).setNamespaceUri(namespaceUri).build());
            return el.getAttributeBuilder(el.getAttributeCount() - 1);
        });
    }

    public static Resources.XmlAttribute.Builder findOrCreateAndroidAttributeBuilder(Resources.XmlElement.Builder el, String name, int resourceId) {
        return el.getAttributeBuilderList().stream().filter(ProtoXmlHelper.attributeWithName(name).and(ProtoXmlHelper.attributeWithResourceId(resourceId)).and(ProtoXmlHelper.attributeWithNamespaceUri(ANDROID_NAMESPACE_URI))).findFirst().orElseGet(() -> {
            el.addAttribute(Resources.XmlAttribute.newBuilder().setName(name).setResourceId(resourceId).setNamespaceUri(ANDROID_NAMESPACE_URI).build());
            return el.getAttributeBuilder(el.getAttributeCount() - 1);
        });
    }

    public static Resources.XmlElement.Builder findOrCreateElementBuilderInDirectChildren(Resources.XmlElement.Builder el, String namespaceUri, String name) {
        return el.getChildBuilderList().stream().filter(node -> node.hasElement()).map(node -> node.getElementBuilder()).filter(ProtoXmlHelper.elementWithName(name).and(ProtoXmlHelper.elementWithNamespace(namespaceUri))).findFirst().orElseGet(() -> {
            el.addChild(Resources.XmlNode.newBuilder().setElement(Resources.XmlElement.newBuilder().setName(name).setNamespaceUri(namespaceUri).build()));
            return el.getChildBuilder(el.getChildCount() - 1).getElementBuilder();
        });
    }

    public static Resources.XmlElement.Builder removeAttribute(Resources.XmlElement.Builder el, String namespaceUri, String name) {
        for (int i = 0; i < el.getAttributeCount(); ++i) {
            if (!el.getAttribute(i).getName().equals(name) || !el.getAttribute(i).getNamespaceUri().equals(namespaceUri)) continue;
            el.removeAttribute(i);
            return el;
        }
        return el;
    }

    public static Optional<Resources.XmlElement> getFirstElement(Resources.XmlNode rootNode, String elementName) {
        List elements = ProtoXmlHelper.findElements(rootNode, elementName).collect(Collectors.toList());
        return elements.isEmpty() ? Optional.empty() : Optional.of(elements.get(0));
    }

    public static Resources.XmlElement getExactlyOneElement(Resources.XmlNode rootNode, String elementName) {
        return ProtoXmlHelper.getExactlyOneElement(rootNode, elementName, NO_NAMESPACE_URI);
    }

    public static Resources.XmlElement getExactlyOneElement(Resources.XmlNode rootNode, String elementName, String namespaceUri) {
        List elements = ProtoXmlHelper.findElements(rootNode, elementName, namespaceUri).collect(Collectors.toList());
        if (elements.size() != 1) {
            throw ValidationException.builder().withMessage("Expected to find exactly one <%s> element (with namespace '%s') but got %s.", elementName, namespaceUri, elements.size()).build();
        }
        return (Resources.XmlElement)elements.get(0);
    }

    public static Resources.XmlElement.Builder getFirstOrCreateElementBuilder(Resources.XmlNode.Builder rootNode, String elementName) {
        List elements = ProtoXmlHelper.findElementBuilders(rootNode, elementName).collect(Collectors.toList());
        if (!elements.isEmpty()) {
            return (Resources.XmlElement.Builder)elements.get(0);
        }
        Preconditions.checkArgument((boolean)rootNode.hasElement(), (Object)"Expecting an element node.");
        Resources.XmlElement.Builder rootElementBuilder = rootNode.getElementBuilder();
        rootElementBuilder.addChild(Resources.XmlNode.newBuilder().setElement(Resources.XmlElement.newBuilder().setName(elementName)));
        return rootElementBuilder.getChildBuilder(rootElementBuilder.getChildCount() - 1).getElementBuilder();
    }

    public static Resources.XmlElement.Builder getExactlyOneElementBuilder(Resources.XmlNode.Builder rootNode, String elementName) {
        List elements = ProtoXmlHelper.findElementBuilders(rootNode, elementName).collect(Collectors.toList());
        if (elements.size() != 1) {
            throw ValidationException.builder().withMessage("Expected to find exactly one <%s> element but got %s.", elementName, elements.size()).build();
        }
        return (Resources.XmlElement.Builder)elements.get(0);
    }

    public static Stream<? extends Resources.XmlNode> flattened(Resources.XmlNode node) {
        return Stream.concat(Stream.of(node), node.hasElement() ? node.getElement().getChildList().stream().flatMap(ProtoXmlHelper::flattened) : Stream.empty());
    }

    public static Stream<? extends Resources.XmlNode.Builder> flattenedBuilders(Resources.XmlNode.Builder node) {
        return Stream.concat(Stream.of(node), node.hasElement() ? node.getElementBuilder().getChildBuilderList().stream().flatMap(ProtoXmlHelper::flattenedBuilders) : Stream.empty());
    }

    public static Stream<Resources.XmlElement> findElements(Resources.XmlNode rootNode, String name) {
        return ProtoXmlHelper.flattened(rootNode).map(node -> node.getElement()).filter(ProtoXmlHelper.elementWithName(name).and(ProtoXmlHelper.elementWithEmptyNamespace()));
    }

    public static Stream<Resources.XmlElement> findElements(Resources.XmlNode rootNode, String name, String namespaceUri) {
        return ProtoXmlHelper.flattened(rootNode).map(node -> node.getElement()).filter(ProtoXmlHelper.elementWithName(name).and(ProtoXmlHelper.elementWithNamespace(namespaceUri)));
    }

    public static Stream<Resources.XmlElement> findElementsFromDirectChildren(Resources.XmlElement xmlElement, String name, String namespaceUri) {
        return xmlElement.getChildList().stream().map(node -> node.getElement()).filter(ProtoXmlHelper.elementWithName(name).and(ProtoXmlHelper.elementWithNamespace(namespaceUri)));
    }

    public static Optional<Resources.XmlElement> findElementFromDirectChildren(Resources.XmlElement xmlElement, String name, String namespaceUri) {
        List matches = ProtoXmlHelper.findElementsFromDirectChildren(xmlElement, name, namespaceUri).collect(Collectors.toList());
        if (matches.size() > 1) {
            throw ValidationException.builder().withMessage("At most one element <%s> with namespace '%s' was expected, but %s were found.", name, namespaceUri, matches.size()).build();
        }
        return matches.isEmpty() ? Optional.empty() : Optional.of(Iterables.getOnlyElement(matches));
    }

    public static Stream<Resources.XmlElement.Builder> findElementBuilders(Resources.XmlNode.Builder rootNode, String name) {
        return ProtoXmlHelper.flattenedBuilders(rootNode).filter(Resources.XmlNode.Builder::hasElement).map(Resources.XmlNode.Builder::getElementBuilder).filter(ProtoXmlHelper.elementWithName(name).and(ProtoXmlHelper.elementWithEmptyNamespace()));
    }

    public static Predicate<Resources.XmlElementOrBuilder> elementWithEmptyNamespace() {
        return element -> element.getNamespaceUri().isEmpty();
    }

    public static Predicate<Resources.XmlElementOrBuilder> elementWithNamespace(String namespaceUri) {
        return element -> namespaceUri.equals(element.getNamespaceUri());
    }

    public static Predicate<Resources.XmlElementOrBuilder> elementWithName(String name) {
        Preconditions.checkNotNull((Object)name);
        return element -> name.equals(element.getName());
    }

    public static Predicate<Resources.XmlAttributeOrBuilder> attributeWithName(String name) {
        Preconditions.checkNotNull((Object)name);
        return attribute -> name.equals(attribute.getName());
    }

    public static Predicate<Resources.XmlAttributeOrBuilder> attributeWithNamespaceUri(String namespaceUri) {
        Preconditions.checkNotNull((Object)namespaceUri);
        return attribute -> namespaceUri.equals(attribute.getNamespaceUri());
    }

    public static Predicate<Resources.XmlAttributeOrBuilder> attributeWithResourceId(int resourceId) {
        return attribute -> attribute.getResourceId() == resourceId;
    }

    private ProtoXmlHelper() {
    }
}

