/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.manifest.AndroidManifest;
import com.android.tools.build.bundletool.model.AbiName;
import com.android.tools.build.bundletool.model.AutoValue_ModuleSplit;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.protobuf.Int32Value;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;

@AutoValue
public abstract class ModuleSplit {
    public abstract Targeting.ApkTargeting getApkTargeting();

    public abstract Targeting.VariantTargeting getVariantTargeting();

    public abstract boolean isStandalone();

    public abstract ImmutableList<ModuleEntry> getEntries();

    public abstract Optional<Resources.ResourceTable> getResourceTable();

    public abstract Optional<AndroidManifest> getAndroidManifest();

    public abstract BundleModuleName getModuleName();

    public abstract boolean isMasterSplit();

    public abstract Optional<Files.NativeLibraries> getNativeConfig();

    public abstract Optional<Files.Assets> getAssetsConfig();

    public abstract Builder toBuilder();

    public boolean isBaseModuleSplit() {
        return this.getModuleName().getName().equals("base");
    }

    public String getSuffix() {
        StringJoiner suffixJoiner = new StringJoiner("_");
        Targeting.AbiTargeting abiTargeting = this.getApkTargeting().getAbiTargeting();
        if (!abiTargeting.getValueList().isEmpty()) {
            abiTargeting.getValueList().forEach(value -> suffixJoiner.add(AbiName.fromProto(value.getAlias()).getPlatformName().replace('-', '_')));
        } else if (!abiTargeting.getAlternativesList().isEmpty()) {
            suffixJoiner.add("other_abis");
        }
        this.getApkTargeting().getLanguageTargeting().getValueList().forEach(suffixJoiner::add);
        this.getApkTargeting().getScreenDensityTargeting().getValueList().forEach(value -> suffixJoiner.add(((String)ResourcesUtils.SCREEN_DENSITY_TO_PROTO_VALUE_MAP.inverse().get((Object)value.getDensityAlias())).replace('-', '_')));
        Targeting.GraphicsApiTargeting graphicsApiTargeting = this.getApkTargeting().getGraphicsApiTargeting();
        if (!graphicsApiTargeting.getValueList().isEmpty()) {
            graphicsApiTargeting.getValueList().forEach(value -> suffixJoiner.add(ModuleSplit.formatGraphicsApi(value)));
        } else if (!graphicsApiTargeting.getAlternativesList().isEmpty()) {
            suffixJoiner.add("other_gl");
        }
        Targeting.TextureCompressionFormatTargeting textureFormatTargeting = this.getApkTargeting().getTextureCompressionFormatTargeting();
        if (!textureFormatTargeting.getValueList().isEmpty()) {
            textureFormatTargeting.getValueList().forEach(value -> suffixJoiner.add(value.getAlias().name().toLowerCase()));
        } else if (!textureFormatTargeting.getAlternativesList().isEmpty()) {
            suffixJoiner.add("other_tcf");
        }
        return suffixJoiner.toString();
    }

    private static String formatGraphicsApi(Targeting.GraphicsApi graphicsTargeting) {
        StringJoiner result = new StringJoiner("_");
        if (graphicsTargeting.hasMinOpenGlVersion()) {
            result.add("gl" + ModuleSplit.formatGlVersion(graphicsTargeting.getMinOpenGlVersion()));
        }
        return result.toString();
    }

    private static String formatGlVersion(Targeting.OpenGlVersion glVersion) {
        return glVersion.getMajor() + "_" + glVersion.getMinor();
    }

    public static ImmutableList<ModuleEntry> filterResourceEntries(ImmutableList<ModuleEntry> entries, Resources.ResourceTable resourceTable) {
        ImmutableSet<ZipPath> referencedPaths = ResourcesUtils.getAllFileReferences(resourceTable);
        return (ImmutableList)entries.stream().filter(entry -> referencedPaths.contains((Object)entry.getPath())).collect(ImmutableList.toImmutableList());
    }

    @CheckReturnValue
    public ModuleSplit writeSplitIdInManifest(String resolvedSplitIdSuffix) {
        Preconditions.checkArgument((boolean)this.getAndroidManifest().isPresent(), (Object)"Missing Android Manifest");
        AndroidManifest moduleManifest = this.getAndroidManifest().get();
        String splitId = this.generateSplitId(resolvedSplitIdSuffix);
        AndroidManifest apkManifest = this.isMasterSplit() ? moduleManifest.toEditor().setSplitIdForFeatureSplit(splitId).save() : AndroidManifest.createForConfigSplit(moduleManifest.getPackageName(), moduleManifest.getVersionCode(), splitId, this.getSplitIdForMasterSplit(), moduleManifest.getExtractNativeLibsValue());
        return this.toBuilder().setAndroidManifest(apkManifest).build();
    }

    private String generateSplitId(String resolvedSuffix) {
        String masterSplitId = this.getSplitIdForMasterSplit();
        if (this.isMasterSplit()) {
            return masterSplitId;
        }
        StringBuilder splitIdBuilder = new StringBuilder(masterSplitId);
        if (splitIdBuilder.length() > 0) {
            splitIdBuilder.append(".");
        }
        return splitIdBuilder.append("config.").append(resolvedSuffix).toString();
    }

    private String getSplitIdForMasterSplit() {
        return this.getModuleName().getNameForSplitId();
    }

    public static Builder builder() {
        return new AutoValue_ModuleSplit.Builder().setEntries((List<ModuleEntry>)ImmutableList.of()).setStandalone(false);
    }

    public static ModuleSplit forModule(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)Predicates.alwaysTrue(), true);
    }

    public static ModuleSplit forResources(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.RESOURCES_DIRECTORY)), true);
    }

    public static ModuleSplit forAssets(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.ASSETS_DIRECTORY)), false);
    }

    public static ModuleSplit forNativeLibraries(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.LIB_DIRECTORY)), false);
    }

    public static ModuleSplit forCode(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.DEX_DIRECTORY)), false);
    }

    public static ModuleSplit forRoot(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.ROOT_DIRECTORY)), false);
    }

    private static ModuleSplit fromBundleModule(BundleModule bundleModule, Predicate<ModuleEntry> entriesPredicate, boolean setResourceTable) {
        Builder splitBuilder = ModuleSplit.builder().setModuleName(bundleModule.getName()).setEntries((List)bundleModule.getEntries().stream().filter(entriesPredicate).collect(ImmutableList.toImmutableList())).setAndroidManifest(bundleModule.getAndroidManifest()).setMasterSplit(true).setStandalone(false).setApkTargeting(Targeting.ApkTargeting.getDefaultInstance()).setVariantTargeting(ModuleSplit.lPlusVariantTargeting());
        bundleModule.getNativeConfig().ifPresent(splitBuilder::setNativeConfig);
        bundleModule.getAssetsConfig().ifPresent(splitBuilder::setAssetsConfig);
        if (setResourceTable) {
            bundleModule.getResourceTable().ifPresent(splitBuilder::setResourceTable);
        }
        return splitBuilder.build();
    }

    public Stream<ModuleEntry> findEntriesUnderPath(String path) {
        return this.getEntries().stream().filter(entry -> entry.getPath().startsWith(path));
    }

    public Stream<ModuleEntry> findEntriesInsideDirectory(String directory) {
        return this.getEntries().stream().filter(entry -> entry.getPath().getParent().equals(ZipPath.create(directory)));
    }

    public Optional<ModuleEntry> findEntry(String path) {
        return (Optional)this.getEntries().stream().filter(entry -> entry.getPath().equals(ZipPath.create(path))).collect(MoreCollectors.toOptional());
    }

    private static Targeting.VariantTargeting lPlusVariantTargeting() {
        return Targeting.VariantTargeting.newBuilder().setSdkVersionTargeting(Targeting.SdkVersionTargeting.newBuilder().addValue(Targeting.SdkVersion.newBuilder().setMin(Int32Value.newBuilder().setValue(21)))).build();
    }

    public static abstract class Builder {
        public abstract Builder setModuleName(BundleModuleName var1);

        public abstract Builder setMasterSplit(boolean var1);

        public abstract Builder setNativeConfig(Files.NativeLibraries var1);

        public abstract Builder setAssetsConfig(Files.Assets var1);

        public abstract Builder setApkTargeting(Targeting.ApkTargeting var1);

        public abstract Builder setVariantTargeting(Targeting.VariantTargeting var1);

        public abstract Builder setStandalone(boolean var1);

        public abstract Builder setEntries(List<ModuleEntry> var1);

        public abstract Builder setResourceTable(Resources.ResourceTable var1);

        public abstract Builder setAndroidManifest(AndroidManifest var1);

        protected abstract ModuleSplit autoBuild();

        public ModuleSplit build() {
            ModuleSplit moduleSplit = this.autoBuild();
            if (moduleSplit.isMasterSplit()) {
                Preconditions.checkState((boolean)moduleSplit.getApkTargeting().toBuilder().clearSdkVersionTargeting().build().equals(Targeting.ApkTargeting.getDefaultInstance()), (Object)"Master split cannot have any targeting other than SDK version.");
            }
            return moduleSplit;
        }
    }
}

