/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AbiNativeLibrariesSplitter
implements ModuleSplitSplitter {
    @Override
    public ImmutableCollection<ModuleSplit> split(ModuleSplit moduleSplit) {
        if (!moduleSplit.getNativeConfig().isPresent()) {
            return ImmutableList.of((Object)moduleSplit);
        }
        ImmutableList.Builder splits = new ImmutableList.Builder();
        List<Files.TargetedNativeDirectory> allTargetedDirectories = moduleSplit.getNativeConfig().get().getDirectoryList();
        ImmutableListMultimap targetingMap = Multimaps.index(allTargetedDirectories, Files.TargetedNativeDirectory::getTargeting);
        ImmutableSet allAbis = (ImmutableSet)targetingMap.keySet().stream().map(Targeting.NativeDirectoryTargeting::getAbi).collect(ImmutableSet.toImmutableSet());
        for (Targeting.NativeDirectoryTargeting targeting : targetingMap.keySet()) {
            ImmutableList.Builder entriesList = new ImmutableList.Builder().addAll((Iterable)targetingMap.get((Object)targeting).stream().flatMap(directory -> moduleSplit.findEntriesUnderPath(directory.getPath())).collect(Collectors.toList()));
            ModuleSplit.Builder splitBuilder = moduleSplit.toBuilder().setApkTargeting(moduleSplit.getApkTargeting().toBuilder().setAbiTargeting(Targeting.AbiTargeting.newBuilder().addValue(targeting.getAbi()).addAllAlternatives((Iterable<? extends Targeting.Abi>)Sets.difference((Set)allAbis, (Set)ImmutableSet.of((Object)targeting.getAbi())))).build()).setMasterSplit(false).setEntries((List<ModuleEntry>)entriesList.build());
            splits.add((Object)splitBuilder.build());
        }
        return splits.build();
    }
}

