/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import shadow.bundletool.com.android.tools.r8.Resource;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;

public interface StringResource
extends Resource {
    public static StringResource fromString(String content, Origin origin) {
        return new StringContentResource(origin, content);
    }

    public static StringResource fromFile(Path file) {
        return StringResource.fromFile(file, StandardCharsets.UTF_8);
    }

    public static StringResource fromFile(Path file, Charset charset) {
        return new FileResource(file, charset);
    }

    public String getString() throws ResourceException;

    public static class FileResource
    implements StringResource {
        private final Path file;
        private final Charset charset;
        private final Origin origin;

        private FileResource(Path file, Charset charset) {
            assert (file != null);
            assert (charset != null);
            this.file = file;
            this.charset = charset;
            this.origin = new PathOrigin(file);
        }

        @Override
        public Origin getOrigin() {
            return this.origin;
        }

        @Override
        public String getString() throws ResourceException {
            try {
                return FileUtils.readTextFile(this.file, this.charset);
            }
            catch (IOException e) {
                throw new ResourceException(this.origin, (Throwable)e);
            }
        }
    }

    public static class StringContentResource
    implements StringResource {
        private final Origin origin;
        private final String content;

        private StringContentResource(Origin origin, String content) {
            assert (origin != null);
            assert (content != null);
            this.origin = origin;
            this.content = content;
        }

        @Override
        public Origin getOrigin() {
            return this.origin;
        }

        @Override
        public String getString() throws ResourceException {
            return this.content;
        }
    }
}

