/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import shadow.bundletool.com.android.tools.r8.ApiLevelException;
import shadow.bundletool.com.android.tools.r8.cf.CfPrinter;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfLabel;
import shadow.bundletool.com.android.tools.r8.cf.code.CfTryCatch;
import shadow.bundletool.com.android.tools.r8.errors.Unimplemented;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class CfCode
extends Code {
    private final DexMethod method;
    private final int maxStack;
    private final int maxLocals;
    private final List<CfInstruction> instructions;
    private final List<CfTryCatch> tryCatchRanges;
    private final List<LocalVariableInfo> localVariables;

    public CfCode(DexMethod method, int maxStack, int maxLocals, List<CfInstruction> instructions, List<CfTryCatch> tryCatchRanges, List<LocalVariableInfo> localVariables) {
        this.method = method;
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
        this.instructions = instructions;
        this.tryCatchRanges = tryCatchRanges;
        this.localVariables = localVariables;
    }

    public DexMethod getMethod() {
        return this.method;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public List<CfInstruction> getInstructions() {
        return Collections.unmodifiableList(this.instructions);
    }

    public List<LocalVariableInfo> getLocalVariables() {
        return Collections.unmodifiableList(this.localVariables);
    }

    @Override
    public boolean isCfCode() {
        return true;
    }

    @Override
    public CfCode asCfCode() {
        return this;
    }

    public void write(MethodVisitor visitor) {
        for (CfInstruction instruction : this.instructions) {
            instruction.write(visitor);
        }
        visitor.visitEnd();
        visitor.visitMaxs(this.maxStack, this.maxLocals);
        for (CfTryCatch tryCatch : this.tryCatchRanges) {
            Label start = tryCatch.start.getLabel();
            Label end = tryCatch.end.getLabel();
            for (int i = 0; i < tryCatch.guards.size(); ++i) {
                DexType guard = tryCatch.guards.get(i);
                Label target = tryCatch.targets.get(i).getLabel();
                visitor.visitTryCatchBlock(start, end, target, guard == DexItemFactory.catchAllType ? null : guard.getInternalName());
            }
        }
        for (LocalVariableInfo localVariable : this.localVariables) {
            DebugLocalInfo info = localVariable.local;
            visitor.visitLocalVariable(info.name.toString(), info.type.toDescriptorString(), info.signature == null ? null : info.signature.toString(), localVariable.start.getLabel(), localVariable.end.getLabel(), localVariable.index);
        }
    }

    @Override
    protected int computeHashCode() {
        throw new Unimplemented();
    }

    @Override
    protected boolean computeEquals(Object other) {
        throw new Unimplemented();
    }

    @Override
    public IRCode buildIR(DexEncodedMethod encodedMethod, InternalOptions options) throws ApiLevelException {
        throw new Unimplemented("Converting Java class- file bytecode to IR not yet supported");
    }

    @Override
    public void registerInstructionsReferences(UseRegistry registry) {
        throw new Unimplemented("Inspecting Java class-file bytecode not yet supported");
    }

    @Override
    public void registerCaughtTypes(Consumer<DexType> dexTypeConsumer) {
        throw new Unimplemented("Inspecting Java class-file bytecode not yet supported");
    }

    @Override
    public String toString() {
        return new CfPrinter(this).toString();
    }

    @Override
    public String toString(DexEncodedMethod method, ClassNameMapper naming) {
        return null;
    }

    public static class LocalVariableInfo {
        private final int index;
        private final DebugLocalInfo local;
        private final CfLabel start;
        private CfLabel end;

        public LocalVariableInfo(int index, DebugLocalInfo local, CfLabel start) {
            this.index = index;
            this.local = local;
            this.start = start;
        }

        public void setEnd(CfLabel end) {
            assert (this.end == null);
            assert (end != null);
            this.end = end;
        }

        public int getIndex() {
            return this.index;
        }

        public DebugLocalInfo getLocal() {
            return this.local;
        }

        public CfLabel getStart() {
            return this.start;
        }

        public CfLabel getEnd() {
            return this.end;
        }
    }
}

