/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import shadow.bundletool.com.android.ddmlib.AdbCommandRejectedException;
import shadow.bundletool.com.android.ddmlib.IShellOutputReceiver;
import shadow.bundletool.com.android.ddmlib.ShellCommandUnresponsiveException;
import shadow.bundletool.com.android.ddmlib.TimeoutException;

public class AdbShellCommandTask {
    private final String command;
    private final Device device;

    public AdbShellCommandTask(Device device, String commandToExecute) {
        this.device = device;
        this.command = commandToExecute;
    }

    public String execute() {
        return this.execute(0L, TimeUnit.SECONDS);
    }

    public String execute(long deadline, TimeUnit deadlineUnits) {
        final ByteArrayOutputStream commandOutput = new ByteArrayOutputStream();
        try {
            this.device.executeShellCommand(this.command, new IShellOutputReceiver(){

                @Override
                public void addOutput(byte[] bytes, int offset, int length) {
                    commandOutput.write(bytes, offset, length);
                }

                @Override
                public void flush() {
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }
            }, deadline, deadlineUnits);
            return commandOutput.toString("UTF-8");
        }
        catch (IOException e) {
            throw CommandExecutionException.builder().withMessage("I/O error while executing adb shell '%s' on device '%s'.", this.command, this.device.getSerialNumber()).withCause(e).build();
        }
        catch (TimeoutException e) {
            throw CommandExecutionException.builder().withMessage("Timeout while executing adb shell '%s' on device '%s'.", this.command, this.device.getSerialNumber()).withCause(e).build();
        }
        catch (ShellCommandUnresponsiveException e) {
            throw CommandExecutionException.builder().withMessage("Unresponsive shell command while executing adb shell '%s' on device '%s'.", this.command, this.device.getSerialNumber()).withCause(e).build();
        }
        catch (AdbCommandRejectedException e) {
            throw CommandExecutionException.builder().withMessage("Rejected adb shell command '%s' on device '%s'.", this.command, this.device.getSerialNumber()).withCause(e).build();
        }
    }
}

