/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.optimizations;

import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.optimizations.AutoValue_ApkOptimizations;
import com.android.tools.build.bundletool.version.Version;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;

@AutoValue
public abstract class ApkOptimizations {
    private static final ImmutableSortedMap<Version, ApkOptimizations> DEFAULT_OPTIMIZATIONS_BY_BUNDLETOOL_VERSION = ImmutableSortedMap.naturalOrder().put((Object)Version.of("0.0.0-dev"), (Object)ApkOptimizations.builder().setSplitDimensions((ImmutableSet<OptimizationDimension>)ImmutableSet.of((Object)((Object)OptimizationDimension.ABI), (Object)((Object)OptimizationDimension.SCREEN_DENSITY), (Object)((Object)OptimizationDimension.LANGUAGE))).build()).build();

    public abstract ImmutableSet<OptimizationDimension> getSplitDimensions();

    static Builder builder() {
        return new AutoValue_ApkOptimizations.Builder();
    }

    public static ApkOptimizations getDefaultOptimizationsForVersion(Version bundleToolVersion) {
        return (ApkOptimizations)((Map.Entry)Preconditions.checkNotNull((Object)DEFAULT_OPTIMIZATIONS_BY_BUNDLETOOL_VERSION.floorEntry((Object)bundleToolVersion), (String)"No default optimizations found for BundleTool version %s.", (Object)bundleToolVersion)).getValue();
    }

    public static ApkOptimizations getOptimizationsForUniversalApk() {
        return ApkOptimizations.builder().setSplitDimensions((ImmutableSet<OptimizationDimension>)ImmutableSet.of()).build();
    }

    static abstract class Builder {
        Builder() {
        }

        abstract Builder setSplitDimensions(ImmutableSet<OptimizationDimension> var1);

        abstract ApkOptimizations build();
    }
}

