/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.cf;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.Printer;
import shadow.bundletool.com.android.tools.r8.cf.code.CfArrayLength;
import shadow.bundletool.com.android.tools.r8.cf.code.CfArrayLoad;
import shadow.bundletool.com.android.tools.r8.cf.code.CfArrayStore;
import shadow.bundletool.com.android.tools.r8.cf.code.CfBinop;
import shadow.bundletool.com.android.tools.r8.cf.code.CfCheckCast;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstClass;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstNull;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstNumber;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstString;
import shadow.bundletool.com.android.tools.r8.cf.code.CfFieldInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfFrame;
import shadow.bundletool.com.android.tools.r8.cf.code.CfGoto;
import shadow.bundletool.com.android.tools.r8.cf.code.CfIf;
import shadow.bundletool.com.android.tools.r8.cf.code.CfIfCmp;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstanceOf;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInvoke;
import shadow.bundletool.com.android.tools.r8.cf.code.CfLabel;
import shadow.bundletool.com.android.tools.r8.cf.code.CfLoad;
import shadow.bundletool.com.android.tools.r8.cf.code.CfMonitor;
import shadow.bundletool.com.android.tools.r8.cf.code.CfMultiANewArray;
import shadow.bundletool.com.android.tools.r8.cf.code.CfNew;
import shadow.bundletool.com.android.tools.r8.cf.code.CfNewArray;
import shadow.bundletool.com.android.tools.r8.cf.code.CfNop;
import shadow.bundletool.com.android.tools.r8.cf.code.CfPop;
import shadow.bundletool.com.android.tools.r8.cf.code.CfPosition;
import shadow.bundletool.com.android.tools.r8.cf.code.CfReturn;
import shadow.bundletool.com.android.tools.r8.cf.code.CfReturnVoid;
import shadow.bundletool.com.android.tools.r8.cf.code.CfStore;
import shadow.bundletool.com.android.tools.r8.cf.code.CfSwitch;
import shadow.bundletool.com.android.tools.r8.cf.code.CfThrow;
import shadow.bundletool.com.android.tools.r8.cf.code.CfUnop;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.CfCode;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.If;
import shadow.bundletool.com.android.tools.r8.ir.code.MemberType;
import shadow.bundletool.com.android.tools.r8.ir.code.Monitor;
import shadow.bundletool.com.android.tools.r8.ir.code.NumericType;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class CfPrinter {
    private final String indent;
    private final Map<CfLabel, String> labels;
    private final StringBuilder builder = new StringBuilder();

    public CfPrinter() {
        this.indent = "";
        this.labels = null;
    }

    public CfPrinter(CfCode code) {
        this.indent = "  ";
        this.labels = new HashMap<CfLabel, String>();
        int nextLabelNumber = 0;
        for (CfInstruction instruction : code.getInstructions()) {
            if (!(instruction instanceof CfLabel)) continue;
            this.labels.put((CfLabel)instruction, "L" + nextLabelNumber++);
        }
        this.builder.append(".method ");
        this.appendMethod(code.getMethod());
        this.newline();
        this.builder.append(".limit stack ").append(code.getMaxStack());
        this.newline();
        this.builder.append(".limit locals ").append(code.getMaxLocals());
        for (CfCode.LocalVariableInfo local : code.getLocalVariables()) {
            DebugLocalInfo info = local.getLocal();
            this.newline();
            this.builder.append(".var ").append(local.getIndex()).append(" is ").append(info.name).append(" ").append(info.type.toDescriptorString()).append(" from ").append(this.getLabel(local.getStart())).append(" to ").append(this.getLabel(local.getEnd()));
            if (info.signature == null) continue;
            this.appendComment(info.signature.toString());
        }
        for (CfInstruction instruction : code.getInstructions()) {
            instruction.print(this);
        }
        this.newline();
        this.builder.append(".end method");
        this.newline();
    }

    private void print(String name) {
        this.indent();
        this.builder.append(name);
    }

    public void print(CfNop nop) {
        this.print("nop");
    }

    public void print(CfThrow insn) {
        this.print("athrow");
    }

    public void print(CfConstNull constNull) {
        this.print("aconst_null");
    }

    public void print(CfConstNumber constNumber) {
        this.indent();
        switch (constNumber.getType()) {
            case INT: {
                this.builder.append("ldc ").append(constNumber.getIntValue());
                break;
            }
            case FLOAT: {
                this.builder.append("ldc ").append(constNumber.getFloatValue());
                break;
            }
            case LONG: {
                this.builder.append("ldc_w ").append(constNumber.getLongValue());
                break;
            }
            case DOUBLE: {
                this.builder.append("ldc_w ").append(constNumber.getDoubleValue());
                break;
            }
            default: {
                throw new Unreachable("Unexpected const-number type: " + (Object)((Object)constNumber.getType()));
            }
        }
    }

    public void print(CfConstClass constClass) {
        this.indent();
        this.builder.append("ldc ");
        this.appendClass(constClass.getType());
    }

    public void print(CfReturnVoid ret) {
        this.print("return");
    }

    public void print(CfReturn ret) {
        this.print(this.typePrefix(ret.getType()) + "return");
    }

    public void print(CfMonitor monitor) {
        this.print(monitor.getType() == Monitor.Type.ENTER ? "monitorenter" : "monitorexit");
    }

    public void print(CfBinop binop) {
        this.print(this.opcodeName(binop.getOpcode()));
    }

    public void print(CfUnop unop) {
        this.print(this.opcodeName(unop.getOpcode()));
    }

    public void print(CfPop pop) {
        this.print("pop");
    }

    public void print(CfConstString constString) {
        this.indent();
        this.builder.append("ldc ").append(constString.getString());
    }

    public void print(CfArrayLoad arrayLoad) {
        this.indent();
        this.builder.append(this.typePrefix(arrayLoad.getType())).append("aload");
    }

    public void print(CfArrayStore arrayStore) {
        this.indent();
        this.builder.append(this.typePrefix(arrayStore.getType())).append("astore");
    }

    public void print(CfInvoke invoke) {
        this.indent();
        this.builder.append(this.opcodeName(invoke.getOpcode())).append(' ');
        this.appendMethod(invoke.getMethod());
    }

    public void print(CfFrame frame) {
        StringBuilder builder = new StringBuilder("frame: ");
        StringUtils.append(builder, frame.getLocals().values(), ", ", StringUtils.BraceType.SQUARE);
        builder.append(' ');
        StringUtils.append(builder, frame.getStack(), ", ", StringUtils.BraceType.SQUARE);
        this.comment(builder.toString());
    }

    public void print(CfInstanceOf insn) {
        this.indent();
        this.builder.append("instanceof ");
        this.appendClass(insn.getType());
    }

    public void print(CfCheckCast insn) {
        this.indent();
        this.builder.append("checkcast ");
        this.appendClass(insn.getType());
    }

    public void print(CfFieldInstruction insn) {
        this.indent();
        switch (insn.getOpcode()) {
            case 180: {
                this.builder.append("getfield ");
                break;
            }
            case 181: {
                this.builder.append("putfield ");
                break;
            }
            case 178: {
                this.builder.append("getstatic ");
                break;
            }
            case 179: {
                this.builder.append("putstatic ");
                break;
            }
            default: {
                throw new Unreachable("Unexpected field-instruction opcode " + insn.getOpcode());
            }
        }
        this.appendField(insn.getField());
        this.builder.append(' ');
        this.appendDescriptor(insn.getField().type);
    }

    public void print(CfNew newInstance) {
        this.indent();
        this.builder.append("new ");
        this.appendClass(newInstance.getType());
    }

    public void print(CfNewArray newArray) {
        this.indent();
        String elementDescriptor = newArray.getType().toDescriptorString().substring(1);
        if (newArray.getType().isPrimitiveArrayType()) {
            this.builder.append("newarray ");
            this.builder.append(DescriptorUtils.descriptorToJavaType(elementDescriptor));
        } else {
            this.builder.append("anewarray ");
            if (elementDescriptor.charAt(0) == '[') {
                this.builder.append(elementDescriptor);
            } else {
                this.builder.append(Type.getType((String)elementDescriptor).getInternalName());
            }
        }
    }

    public void print(CfMultiANewArray multiANewArray) {
        this.indent();
        this.builder.append("multianewarray ");
        this.appendClass(multiANewArray.getType());
        this.builder.append(' ').append(multiANewArray.getDimensions());
    }

    public void print(CfArrayLength arrayLength) {
        this.print("arraylength");
    }

    public void print(CfLabel label) {
        this.newline();
        this.builder.append(this.getLabel(label)).append(':');
    }

    public void print(CfPosition instruction) {
        Position position = instruction.getPosition();
        this.indent();
        this.builder.append(".line ").append(position.line);
        if (position.file != null || position.callerPosition != null) {
            this.appendComment(position.toString());
        }
    }

    public void print(CfGoto jump) {
        this.indent();
        this.builder.append("goto ").append(this.getLabel(jump.getTarget()));
    }

    private String ifPostfix(If.Type kind) {
        return kind.toString().toLowerCase();
    }

    public void print(CfIf conditional) {
        this.indent();
        if (conditional.getType().isObject()) {
            this.builder.append("if").append(conditional.getKind() == If.Type.EQ ? "null" : "nonnull");
        } else {
            this.builder.append("if").append(this.ifPostfix(conditional.getKind()));
        }
        this.builder.append(' ').append(this.getLabel(conditional.getTarget()));
    }

    public void print(CfIfCmp conditional) {
        this.indent();
        this.builder.append(conditional.getType().isObject() ? "if_acmp" : "if_icmp").append(this.ifPostfix(conditional.getKind())).append(' ').append(this.getLabel(conditional.getTarget()));
    }

    public void print(CfSwitch cfSwitch) {
        this.indent();
        this.builder.append(cfSwitch.getKind() == CfSwitch.Kind.LOOKUP ? "lookup" : "table").append("switch");
        IntList keys = cfSwitch.getKeys();
        List<CfLabel> targets = cfSwitch.getTargets();
        for (int i = 0; i < keys.size(); ++i) {
            this.indent();
            this.builder.append("  ").append(keys.getInt(i)).append(": ").append(this.getLabel(targets.get(i)));
        }
        this.indent();
        this.builder.append("  default: ").append(this.getLabel(cfSwitch.getDefaultTarget()));
    }

    public void print(CfLoad load) {
        this.printPrefixed(load.getType(), "load", load.getLocalIndex());
    }

    public void print(CfStore store) {
        this.printPrefixed(store.getType(), "store", store.getLocalIndex());
    }

    private void printPrefixed(ValueType type, String instruction, int local) {
        this.indent();
        this.builder.append(this.typePrefix(type)).append(instruction).append(' ').append(local);
    }

    private char typePrefix(ValueType type) {
        switch (type) {
            case OBJECT: {
                return 'a';
            }
            case INT: {
                return 'i';
            }
            case FLOAT: {
                return 'f';
            }
            case LONG: {
                return 'l';
            }
            case DOUBLE: {
                return 'd';
            }
        }
        throw new Unreachable("Unexpected type for prefix: " + (Object)((Object)type));
    }

    public char typePrefix(MemberType type) {
        switch (type) {
            case OBJECT: {
                return 'a';
            }
            case BOOLEAN: 
            case BYTE: {
                return 'b';
            }
            case CHAR: {
                return 'c';
            }
            case SHORT: {
                return 's';
            }
            case INT: {
                return 'i';
            }
            case FLOAT: {
                return 'f';
            }
            case LONG: {
                return 'l';
            }
            case DOUBLE: {
                return 'd';
            }
        }
        throw new Unreachable("Unexpected member type for prefix: " + (Object)((Object)type));
    }

    public char typePrefix(NumericType type) {
        switch (type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return 'i';
            }
            case FLOAT: {
                return 'f';
            }
            case LONG: {
                return 'l';
            }
            case DOUBLE: {
                return 'd';
            }
        }
        throw new Unreachable("Unexpected numeric type for prefix: " + (Object)((Object)type));
    }

    private String getLabel(CfLabel label) {
        return this.labels != null ? this.labels.get(label) : "L?";
    }

    private void newline() {
        if (this.builder.length() > 0) {
            this.builder.append('\n');
        }
    }

    private void indent() {
        this.newline();
        this.builder.append(this.indent);
    }

    private void comment(String comment) {
        this.indent();
        this.builder.append("; ").append(comment);
    }

    private void appendComment(String comment) {
        this.builder.append(" ; ").append(comment);
    }

    private void appendDescriptor(DexType type) {
        this.builder.append(type.toDescriptorString());
    }

    private void appendClass(DexType type) {
        this.builder.append(type.getInternalName());
    }

    private void appendField(DexField field) {
        this.appendClass(field.getHolder());
        this.builder.append('/').append(field.name);
    }

    private void appendMethod(DexMethod method) {
        this.builder.append(method.qualifiedName());
        this.builder.append(method.proto.toDescriptorString());
    }

    private String opcodeName(int opcode) {
        return Printer.OPCODES[opcode].toLowerCase();
    }

    public String toString() {
        return this.builder.toString();
    }
}

