/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.device.DeviceAnalyzer;
import com.android.tools.build.bundletool.device.DeviceSpecParser;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.io.ApkSerializerManager;
import com.android.tools.build.bundletool.io.ApkSetBuilderFactory;
import com.android.tools.build.bundletool.io.SplitApkSerializer;
import com.android.tools.build.bundletool.io.StandaloneApkSerializer;
import com.android.tools.build.bundletool.model.Aapt2Command;
import com.android.tools.build.bundletool.model.ApkModifier;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.GeneratedApks;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.android.tools.build.bundletool.optimizations.OptimizationsMerger;
import com.android.tools.build.bundletool.splitters.BundleSharder;
import com.android.tools.build.bundletool.splitters.ModuleSplitter;
import com.android.tools.build.bundletool.targeting.AlternativeVariantTargetingPopulator;
import com.android.tools.build.bundletool.utils.SdkToolsLocator;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.validation.AppBundleValidator;
import com.android.tools.build.bundletool.version.BundleToolVersion;
import com.android.tools.build.bundletool.version.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.zip.ZipFile;

final class BuildApksManager {
    private final BuildApksCommand command;

    BuildApksManager(BuildApksCommand command) {
        this.command = command;
    }

    public Path execute(Path tempDir) {
        this.validateInput();
        Aapt2Command aapt2Command = this.command.getAapt2Command().orElseGet(() -> BuildApksManager.extractAapt2FromJar(tempDir));
        Optional<Object> deviceSpec = Optional.empty();
        if (this.command.getGenerateOnlyForConnectedDevice()) {
            deviceSpec = Optional.of(this.getDeviceSpec());
        } else if (this.command.getDeviceSpecPath().isPresent()) {
            deviceSpec = Optional.of(DeviceSpecParser.parseDeviceSpec(this.command.getDeviceSpecPath().get()));
        }
        try (ZipFile bundleZip = new ZipFile(this.command.getBundlePath().toFile());){
            boolean generateInstantApks;
            AppBundleValidator bundleValidator = new AppBundleValidator();
            bundleValidator.validateFile(bundleZip);
            AppBundle appBundle = AppBundle.buildFromZip(bundleZip);
            bundleValidator.validate(appBundle);
            Config.BundleConfig bundleConfig = appBundle.getBundleConfig();
            Version bundleVersion = BundleToolVersion.getVersionFromBundleConfig(bundleConfig);
            ImmutableList allModules = ImmutableList.copyOf((Collection)appBundle.getModules().values());
            ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder = this.createApkSetBuilder(aapt2Command, this.command.getSigningConfiguration(), bundleConfig.getCompression(), tempDir);
            ApkOptimizations apkOptimizations = this.command.getGenerateOnlyUniversalApk() ? ApkOptimizations.getOptimizationsForUniversalApk() : new OptimizationsMerger().mergeWithDefaults(bundleConfig, this.command.getOptimizationDimensions());
            boolean generateSplitApks = !this.command.getGenerateOnlyUniversalApk() && !BuildApksManager.targetsOnlyPreL(appBundle);
            boolean generateStandaloneApks = this.command.getGenerateOnlyUniversalApk() || BuildApksManager.targetsPreL(appBundle);
            boolean bl = generateInstantApks = generateSplitApks && !deviceSpec.isPresent();
            if (deviceSpec.isPresent()) {
                if (((Devices.DeviceSpec)deviceSpec.get()).getSdkVersion() >= 21) {
                    generateStandaloneApks = false;
                    if (!generateSplitApks) {
                        throw new CommandExecutionException("App Bundle targets pre-L devices, but the device has SDK version higher or equal to L.");
                    }
                } else {
                    generateSplitApks = false;
                    if (!generateStandaloneApks) {
                        throw new CommandExecutionException("App Bundle targets L+ devices, but the device has SDK version lower than L.");
                    }
                }
            }
            GeneratedApks.Builder generatedApksBuilder = GeneratedApks.builder();
            if (generateSplitApks) {
                generatedApksBuilder.setSplitApks(this.generateSplitApks((ImmutableList<BundleModule>)allModules, apkOptimizations, bundleVersion, ModuleSplitter::splitModule));
            }
            if (generateInstantApks) {
                ImmutableList instantModules = (ImmutableList)allModules.stream().filter(BundleModule::isInstantModule).collect(ImmutableList.toImmutableList());
                generatedApksBuilder.setInstantApks(this.generateSplitApks((ImmutableList<BundleModule>)instantModules, apkOptimizations, bundleVersion, ModuleSplitter::splitInstantModule));
            }
            if (generateStandaloneApks) {
                ImmutableList modulesForFusing = (ImmutableList)allModules.stream().filter(BundleModule::isIncludedInFusing).collect(ImmutableList.toImmutableList());
                generatedApksBuilder.setStandaloneApks(this.generateStandaloneApks((ImmutableList<BundleModule>)modulesForFusing, appBundle.getBundleMetadata(), this.command.getGenerateOnlyUniversalApk(), tempDir, apkOptimizations, bundleVersion));
            }
            GeneratedApks generatedApks = AlternativeVariantTargetingPopulator.populateAlternativeVariantTargeting(generatedApksBuilder.build());
            ApkSerializerManager apkSerializerManager = new ApkSerializerManager(appBundle, apkSetBuilder, this.command.getExecutorService(), this.command.getApkModifier().orElse(ApkModifier.NO_OP), this.command.getFirstVariantNumber().orElse(0));
            ImmutableList<Commands.Variant> allVariantsWithTargeting = deviceSpec.isPresent() ? apkSerializerManager.serializeApksForDevice(generatedApks, (Devices.DeviceSpec)deviceSpec.get()) : (this.command.getGenerateOnlyUniversalApk() ? apkSerializerManager.serializeUniversalApk(generatedApks) : apkSerializerManager.serializeApks(generatedApks));
            apkSetBuilder.setTableOfContentsFile(Commands.BuildApksResult.newBuilder().addAllVariant((Iterable<? extends Commands.Variant>)allVariantsWithTargeting).setBundletool(Config.Bundletool.newBuilder().setVersion(BundleToolVersion.getCurrentVersion().toString())).build());
            if (this.command.getOverwriteOutput()) {
                Files.deleteIfExists(this.command.getOutputFile());
            }
            apkSetBuilder.writeTo(this.command.getOutputFile());
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("An error occurred when processing the bundle '%s'.", this.command.getBundlePath()), e);
        }
        finally {
            if (this.command.isExecutorServiceCreatedByBundleTool()) {
                this.command.getExecutorService().shutdown();
            }
        }
        return this.command.getOutputFile();
    }

    private Devices.DeviceSpec getDeviceSpec() {
        AdbServer adbServer = this.command.getAdbServer().get();
        adbServer.init(this.command.getAdbPath().get());
        return new DeviceAnalyzer(adbServer).getDeviceSpec(this.command.getDeviceId());
    }

    private ApkSetBuilderFactory.ApkSetBuilder createApkSetBuilder(Aapt2Command aapt2Command, Optional<SigningConfiguration> signingConfiguration, Config.Compression compression, Path tempDir) {
        SplitApkSerializer splitApkSerializer = new SplitApkSerializer(aapt2Command, signingConfiguration, compression);
        StandaloneApkSerializer standaloneApkSerializer = new StandaloneApkSerializer(aapt2Command, signingConfiguration, compression);
        return ApkSetBuilderFactory.createApkSetBuilder(splitApkSerializer, standaloneApkSerializer, tempDir);
    }

    private static Aapt2Command extractAapt2FromJar(Path tempDir) {
        return new SdkToolsLocator().extractAapt2(tempDir).map(Aapt2Command::createFromExecutablePath).orElseThrow(() -> new CommandExecutionException("Could not extract aapt2: consider updating bundletool to a more recent version or providing the path to aapt2 using the flag --aapt2."));
    }

    private void validateInput() {
        FilePreconditions.checkFileExistsAndReadable(this.command.getBundlePath());
        if (!this.command.getOverwriteOutput()) {
            FilePreconditions.checkFileDoesNotExist(this.command.getOutputFile());
        }
        if (this.command.getGenerateOnlyForConnectedDevice()) {
            Preconditions.checkArgument((boolean)this.command.getAdbServer().isPresent(), (Object)"Property 'adbServer' is required when 'generateOnlyForConnectedDevice' is true.");
            Preconditions.checkArgument((boolean)this.command.getAdbPath().isPresent(), (Object)"Property 'adbPath' is required when 'generateOnlyForConnectedDevice' is true.");
            FilePreconditions.checkFileExistsAndExecutable(this.command.getAdbPath().get());
        }
    }

    private ImmutableList<ModuleSplit> generateSplitApks(ImmutableList<BundleModule> modules, ApkOptimizations apkOptimizations, Version bundleVersion, Function<ModuleSplitter, ImmutableList<ModuleSplit>> splitter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BundleModule module : modules) {
            ModuleSplitter moduleSplitter = new ModuleSplitter(module, apkOptimizations.getSplitDimensions(), bundleVersion);
            boolean enableNativeLibraryCompressionSplitter = apkOptimizations.getUncompressNativeLibraries();
            moduleSplitter.setEnableNativeLibraryCompressionSplitter(enableNativeLibraryCompressionSplitter);
            ImmutableList<ModuleSplit> splitApks = splitter.apply(moduleSplitter);
            builder.addAll(splitApks);
        }
        return builder.build();
    }

    private ImmutableList<ModuleSplit> generateStandaloneApks(ImmutableList<BundleModule> modules, BundleMetadata bundleMetadata, boolean isUniversalApk, Path tempDir, ApkOptimizations apkOptimizations, Version bundleVersion) {
        ImmutableList<ModuleSplit> standaloneApks = new BundleSharder(tempDir, bundleVersion).shardBundle(modules, apkOptimizations.getSplitDimensions(), bundleMetadata);
        return (ImmutableList)standaloneApks.stream().map(moduleSplit -> moduleSplit.toBuilder().setVariantTargeting(isUniversalApk ? Targeting.VariantTargeting.getDefaultInstance() : BuildApksManager.standaloneApkVariantTargeting(moduleSplit)).setSplitType(ModuleSplit.SplitType.STANDALONE).build()).collect(ImmutableList.toImmutableList());
    }

    private static boolean targetsOnlyPreL(AppBundle bundle) {
        Optional<Integer> maxSdkVersion = bundle.getBaseModule().getAndroidManifest().getMaxSdkVersion();
        return maxSdkVersion.isPresent() && maxSdkVersion.get() < 21;
    }

    private static boolean targetsPreL(AppBundle bundle) {
        int baseMinSdkVersion = bundle.getBaseModule().getAndroidManifest().getEffectiveMinSdkVersion();
        return baseMinSdkVersion < 21;
    }

    private static Targeting.VariantTargeting standaloneApkVariantTargeting(ModuleSplit standaloneApk) {
        Targeting.ApkTargeting apkTargeting = standaloneApk.getApkTargeting();
        Targeting.VariantTargeting.Builder variantTargeting = Targeting.VariantTargeting.newBuilder();
        if (apkTargeting.hasAbiTargeting()) {
            variantTargeting.setAbiTargeting(apkTargeting.getAbiTargeting());
        }
        if (apkTargeting.hasScreenDensityTargeting()) {
            variantTargeting.setScreenDensityTargeting(apkTargeting.getScreenDensityTargeting());
        }
        variantTargeting.setSdkVersionTargeting(Targeting.SdkVersionTargeting.newBuilder().addValue(Targeting.SdkVersion.getDefaultInstance()));
        return variantTargeting.build();
    }
}

