/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.exceptions.DeviceNotFoundException;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;

public class ApksInstaller {
    private final AdbServer adbServer;
    private static final int ADB_TIMEOUT_MS = 60000;

    public ApksInstaller(AdbServer adbServer) {
        this.adbServer = adbServer;
    }

    public void installApks(ImmutableList<Path> apkPaths) {
        try {
            this.installApks(apkPaths, (Predicate<Device>)Predicates.alwaysTrue());
        }
        catch (DeviceNotFoundException.TooManyDevicesMatchedException e) {
            throw CommandExecutionException.builder().withMessage("Expected to find one connected device, but found %d.", e.getMatchedNumber()).build();
        }
        catch (DeviceNotFoundException e) {
            throw CommandExecutionException.builder().withMessage("Expected to find one connected device, but found none.").build();
        }
    }

    public void installApks(ImmutableList<Path> apkPaths, String deviceId) {
        try {
            this.installApks(apkPaths, (Device device) -> device.getSerialNumber().equals(deviceId));
        }
        catch (DeviceNotFoundException e) {
            throw CommandExecutionException.builder().withMessage("Expected to find one connected device with serial number '%s'.", deviceId).build();
        }
    }

    private void installApks(ImmutableList<Path> apkPaths, Predicate<Device> deviceFilter) {
        try {
            ImmutableList matchedDevices = (ImmutableList)this.adbServer.getDevices().stream().filter(deviceFilter).collect(ImmutableList.toImmutableList());
            if (matchedDevices.isEmpty()) {
                throw new DeviceNotFoundException("Unable to find a device matching the criteria.", new Object[0]);
            }
            if (matchedDevices.size() > 1) {
                throw new DeviceNotFoundException.TooManyDevicesMatchedException(matchedDevices.size());
            }
            this.installOnDevice(apkPaths, (Device)matchedDevices.get(0));
        }
        catch (TimeoutException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("Timed out while waiting for ADB.").build();
        }
    }

    private void installOnDevice(ImmutableList<Path> apkPaths, Device device) {
        device.installApks(apkPaths, true, 60000L, TimeUnit.MILLISECONDS);
    }
}

