/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.tools.build.bundletool.io.SplitApkSerializer;
import com.android.tools.build.bundletool.io.StandaloneApkSerializer;
import com.android.tools.build.bundletool.io.ZipBuilder;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;

public final class ApkSetBuilderFactory {
    public static ApkSetBuilder createApkSetBuilder(SplitApkSerializer splitApkSerializer, StandaloneApkSerializer standaloneApkSerializer, Path tempDir) {
        return new ApkSetArchiveBuilder(splitApkSerializer, standaloneApkSerializer, tempDir);
    }

    public static class ApkSetArchiveBuilder
    implements ApkSetBuilder {
        private final SplitApkSerializer splitApkSerializer;
        private final StandaloneApkSerializer standaloneApkSerializer;
        private final ZipBuilder apkSetZipBuilder;
        private final Path tempDirectory;

        public ApkSetArchiveBuilder(SplitApkSerializer splitApkSerializer, StandaloneApkSerializer standaloneApkSerializer, Path tempDirectory) {
            this.splitApkSerializer = splitApkSerializer;
            this.standaloneApkSerializer = standaloneApkSerializer;
            this.tempDirectory = tempDirectory;
            this.apkSetZipBuilder = new ZipBuilder();
        }

        @Override
        public Commands.ApkDescription addSplitApk(ModuleSplit split) {
            Commands.ApkDescription apkDescription = this.splitApkSerializer.writeSplitToDisk(split, this.tempDirectory);
            this.addToApkSetArchive(apkDescription);
            return apkDescription;
        }

        @Override
        public Commands.ApkDescription addInstantApk(ModuleSplit split) {
            Commands.ApkDescription apkDescription = this.splitApkSerializer.writeInstantSplitToDisk(split, this.tempDirectory);
            this.addToApkSetArchive(apkDescription);
            return apkDescription;
        }

        @Override
        public Commands.ApkDescription addStandaloneApk(ModuleSplit split) {
            Commands.ApkDescription apkDescription = this.standaloneApkSerializer.writeToDisk(split, this.tempDirectory);
            this.addToApkSetArchive(apkDescription);
            return apkDescription;
        }

        @Override
        public Commands.ApkDescription addStandaloneUniversalApk(ModuleSplit split) {
            Commands.ApkDescription apkDescription = this.standaloneApkSerializer.writeToDiskAsUniversal(split, this.tempDirectory);
            this.addToApkSetArchive(apkDescription);
            return apkDescription;
        }

        private void addToApkSetArchive(Commands.ApkDescription apkDescription) {
            Path apkPath = this.tempDirectory.resolve(apkDescription.getPath());
            FilePreconditions.checkFileExistsAndReadable(apkPath);
            this.apkSetZipBuilder.addFileFromDisk(ZipPath.create(apkDescription.getPath()), apkPath.toFile(), ZipBuilder.EntryOption.UNCOMPRESSED);
        }

        @Override
        public void setTableOfContentsFile(Commands.BuildApksResult tableOfContentsProto) {
            this.apkSetZipBuilder.addFileWithProtoContent(ZipPath.create("toc.pb"), (MessageLite)tableOfContentsProto, new ZipBuilder.EntryOption[0]);
        }

        @Override
        public void writeTo(Path destinationPath) {
            try {
                this.apkSetZipBuilder.writeTo(destinationPath);
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Error while writing the APK Set archive to '%s'.", destinationPath), e);
            }
        }
    }

    public static interface ApkSetBuilder {
        public Commands.ApkDescription addSplitApk(ModuleSplit var1);

        public Commands.ApkDescription addStandaloneApk(ModuleSplit var1);

        public Commands.ApkDescription addStandaloneUniversalApk(ModuleSplit var1);

        public Commands.ApkDescription addInstantApk(ModuleSplit var1);

        public void setTableOfContentsFile(Commands.BuildApksResult var1);

        public void writeTo(Path var1);
    }
}

