/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.model.Aapt2Command;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.concurrent.GuardedBy;

public class SplitApkSerializer {
    private static final ZipPath SPLIT_APKS_SUB_DIR = ZipPath.create("splits");
    private static final ZipPath INSTANT_APKS_SUB_DIR = ZipPath.create("instant");
    private final SuffixManager suffixManager = new SuffixManager();
    private final ApkSerializerHelper apkSerializerHelper;

    public SplitApkSerializer(Aapt2Command aapt2Command, Optional<SigningConfiguration> signingConfig, Config.Compression compression) {
        this.apkSerializerHelper = new ApkSerializerHelper(aapt2Command, signingConfig, compression);
    }

    public Commands.ApkDescription writeSplitToDisk(ModuleSplit split, Path outputDirectory) {
        return this.writeToDisk(split, outputDirectory, SPLIT_APKS_SUB_DIR, Commands.ApkDescription.Builder::setSplitApkMetadata);
    }

    public Commands.ApkDescription writeInstantSplitToDisk(ModuleSplit split, Path outputDirectory) {
        return this.writeToDisk(split, outputDirectory, INSTANT_APKS_SUB_DIR, Commands.ApkDescription.Builder::setInstantApkMetadata);
    }

    private Commands.ApkDescription writeToDisk(ModuleSplit split, Path outputDirectory, ZipPath subDirectoryInApkSet, BiFunction<Commands.ApkDescription.Builder, Commands.SplitApkMetadata, Commands.ApkDescription.Builder> setApkMetadata) {
        Preconditions.checkState((boolean)Files.isDirectory(outputDirectory, new LinkOption[0]));
        String apkFileName = this.getApkFileName(split, split.getModuleName());
        String apkFileRelPath = subDirectoryInApkSet.resolve(apkFileName).toString();
        this.apkSerializerHelper.writeToZipFile(split, outputDirectory.resolve(apkFileRelPath));
        Commands.ApkDescription.Builder builder = Commands.ApkDescription.newBuilder().setPath(apkFileRelPath).setTargeting(split.getApkTargeting());
        return setApkMetadata.apply(builder, Commands.SplitApkMetadata.newBuilder().setSplitId(split.getAndroidManifest().getSplitId().orElse("")).setIsMasterSplit(split.isMasterSplit()).build()).build();
    }

    private String getApkFileName(ModuleSplit apk, BundleModuleName moduleName) {
        String splitId = apk.getAndroidManifest().getSplitId().orElse("");
        String fileSuffix = apk.isMasterSplit() ? "master" : (String)Iterables.getLast(Arrays.asList(splitId.split("\\.")));
        String prefix = apk.getSplitType() == ModuleSplit.SplitType.INSTANT ? "instant-" : "";
        return String.format("%s%s.apk", prefix, this.suffixManager.resolveSuffix(String.format("%s-%s", moduleName.getName(), fileSuffix)));
    }

    private static class SuffixManager {
        @GuardedBy(value="this")
        private final Set<String> usedSuffixes = new HashSet<String>();

        private SuffixManager() {
        }

        synchronized String resolveSuffix(String proposedSuffix) {
            String currentProposal = proposedSuffix;
            int serialNumber = 1;
            while (this.usedSuffixes.contains(currentProposal)) {
                currentProposal = String.format("%s_%d", proposedSuffix, ++serialNumber);
            }
            this.usedSuffixes.add(currentProposal);
            return currentProposal;
        }
    }
}

