/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.exceptions.manifest.ManifestFusingException;
import com.android.tools.build.bundletool.exceptions.manifest.ManifestVersionException;
import com.android.tools.build.bundletool.model.AutoValue_AndroidManifest;
import com.android.tools.build.bundletool.model.DeviceFeatureCondition;
import com.android.tools.build.bundletool.model.ManifestEditor;
import com.android.tools.build.bundletool.model.ManifestMutator;
import com.android.tools.build.bundletool.model.ModuleConditions;
import com.android.tools.build.bundletool.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.utils.xmlproto.XmlProtoElement;
import com.android.tools.build.bundletool.utils.xmlproto.XmlProtoElementBuilder;
import com.android.tools.build.bundletool.utils.xmlproto.XmlProtoNode;
import com.android.tools.build.bundletool.utils.xmlproto.XmlProtoNodeBuilder;
import com.android.tools.build.bundletool.version.Version;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;

@AutoValue
public abstract class AndroidManifest {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    public static final String ANDROID_NAMESPACE = "http://schemas.android.com/apk/res/android";
    public static final String DISTRIBUTION_NAMESPACE = "http://schemas.android.com/apk/distribution";
    public static final String APPLICATION_ELEMENT_NAME = "application";
    public static final String META_DATA_ELEMENT_NAME = "meta-data";
    public static final String SUPPORTS_GL_TEXTURE_ELEMENT_NAME = "supports-gl-texture";
    public static final String USES_FEATURE_ELEMENT_NAME = "uses-feature";
    public static final String USES_SDK_ELEMENT_NAME = "uses-sdk";
    public static final String ACTIVITY_ELEMENT_NAME = "activity";
    public static final String SERVICE_ELEMENT_NAME = "service";
    public static final String PROVIDER_ELEMENT_NAME = "provider";
    public static final String DEBUGGABLE_ATTRIBUTE_NAME = "debuggable";
    public static final String EXTRACT_NATIVE_LIBS_ATTRIBUTE_NAME = "extractNativeLibs";
    public static final String GL_VERSION_ATTRIBUTE_NAME = "glEsVersion";
    public static final String MAX_SDK_VERSION_ATTRIBUTE_NAME = "maxSdkVersion";
    public static final String MIN_SDK_VERSION_ATTRIBUTE_NAME = "minSdkVersion";
    public static final String NAME_ATTRIBUTE_NAME = "name";
    public static final String VALUE_ATTRIBUTE_NAME = "value";
    public static final String CONDITION_DEVICE_FEATURE_NAME = "device-feature";
    public static final String CONDITION_MIN_SDK_VERSION_NAME = "min-sdk";
    public static final String SPLIT_NAME_ATTRIBUTE_NAME = "splitName";
    public static final int DEBUGGABLE_RESOURCE_ID = 0x101000F;
    public static final int EXTRACT_NATIVE_LIBS_RESOURCE_ID = 16844010;
    public static final int HAS_CODE_RESOURCE_ID = 0x101000C;
    public static final int MAX_SDK_VERSION_RESOURCE_ID = 16843377;
    public static final int MIN_SDK_VERSION_RESOURCE_ID = 16843276;
    public static final int NAME_RESOURCE_ID = 0x1010003;
    public static final int VALUE_RESOURCE_ID = 16842788;
    public static final int RESOURCE_RESOURCE_ID = 16842789;
    public static final int VERSION_CODE_RESOURCE_ID = 16843291;
    public static final int IS_FEATURE_SPLIT_RESOURCE_ID = 16844123;
    public static final int GL_ES_VERSION_RESOURCE_ID = 16843393;
    public static final int TARGET_SANDBOX_VERSION_RESOURCE_ID = 16844108;
    public static final int SPLIT_NAME_RESOURCE_ID = 16844105;
    public static final String META_DATA_KEY_FUSED_MODULE_NAMES = "shadow.bundletool.com.android.dynamic.apk.fused.modules";

    public abstract XmlProtoNode getManifestRoot();

    XmlProtoElement getManifestElement() {
        return (XmlProtoElement)this.getManifestRoot().getElement();
    }

    public static AndroidManifest create(XmlProtoNode manifestRoot) {
        return new AutoValue_AndroidManifest(manifestRoot);
    }

    public static AndroidManifest create(Resources.XmlNode manifestRoot) {
        return AndroidManifest.create(new XmlProtoNode(manifestRoot));
    }

    public static AndroidManifest createForConfigSplit(String packageName, int versionCode, String splitId, String featureSplitId, Optional<Boolean> extractNativeLibs) {
        Preconditions.checkNotNull((Object)splitId);
        Preconditions.checkArgument((!splitId.isEmpty() ? 1 : 0) != 0, (Object)"Split Id cannot be empty for config split.");
        Preconditions.checkNotNull((Object)featureSplitId);
        Preconditions.checkNotNull((Object)packageName);
        ManifestEditor editor = new ManifestEditor(AndroidManifest.createMinimalManifestTag()).setPackage(packageName).setVersionCode(versionCode).setSplitId(splitId).setConfigForSplit(featureSplitId).setHasCode(false);
        extractNativeLibs.ifPresent(editor::setExtractNativeLibsValue);
        return editor.save();
    }

    private static XmlProtoNode createMinimalManifestTag() {
        return XmlProtoNode.createElementNode(XmlProtoElementBuilder.create("manifest").addNamespaceDeclaration("android", ANDROID_NAMESPACE).build());
    }

    public boolean getEffectiveApplicationDebuggable() {
        return this.getApplicationDebuggable().orElse(false);
    }

    @CheckReturnValue
    public AndroidManifest applyMutators(ImmutableList<ManifestMutator> manifestMutators) {
        XmlProtoNodeBuilder xmlProtoNode = this.getManifestRoot().toBuilder();
        for (ManifestMutator manifestMutator : manifestMutators) {
            manifestMutator.accept(xmlProtoNode.getElement());
        }
        return AndroidManifest.create(xmlProtoNode.build().getProto());
    }

    public Optional<Boolean> getApplicationDebuggable() {
        return this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME).flatMap(app -> app.getAndroidAttribute(0x101000F)).map(attr -> attr.getValueAsBoolean());
    }

    public Optional<Integer> getMinSdkVersion() {
        return this.getUsesSdkAttribute(16843276);
    }

    public int getEffectiveMinSdkVersion() {
        return this.getMinSdkVersion().orElse(1);
    }

    public Optional<Integer> getMaxSdkVersion() {
        return this.getUsesSdkAttribute(16843377);
    }

    public Optional<Integer> getTargetSandboxVersion() {
        return this.getManifestElement().getAndroidAttribute(16844108).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsDecimalInteger());
    }

    private Optional<Integer> getUsesSdkAttribute(int attributeResId) {
        return this.getManifestElement().getOptionalChildElement(USES_SDK_ELEMENT_NAME).flatMap(usesSdk -> usesSdk.getAndroidAttribute(attributeResId)).map(attribute -> attribute.getValueAsDecimalInteger());
    }

    public Optional<Boolean> getHasCode() {
        return this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME).flatMap(application -> application.getAndroidAttribute(0x101000C)).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean());
    }

    public Optional<Boolean> getIsFeatureSplit() {
        return this.getManifestElement().getAndroidAttribute(16844123).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean());
    }

    public Optional<Boolean> getIsModuleIncludedInFusing(Version bundleToolVersion) {
        return this.getManifestElement().getOptionalChildElement(DISTRIBUTION_NAMESPACE, "module").flatMap(module -> module.getOptionalChildElement(DISTRIBUTION_NAMESPACE, "fusing")).map(fusing -> {
            if (bundleToolVersion.isOlderThan(Version.of("0.3.4-dev"))) {
                return (XmlProtoAttribute)fusing.getAttributeIgnoringNamespace("include").orElseThrow(() -> new ManifestFusingException.FusingMissingIncludeAttribute(this.getSplitId()));
            }
            return (XmlProtoAttribute)fusing.getAttribute(DISTRIBUTION_NAMESPACE, "include").orElseThrow(() -> new ManifestFusingException.FusingMissingIncludeAttribute(this.getSplitId()));
        }).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean());
    }

    public Optional<String> getConfigForSplit() {
        return this.getManifestElement().getAttribute("configForSplit").map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString());
    }

    public String getPackageName() {
        return ((XmlProtoAttribute)this.getManifestElement().getAttribute("package").orElseThrow(() -> new ValidationException("Package name not found in the manifest."))).getValueAsString();
    }

    public int getVersionCode() {
        return ((XmlProtoAttribute)this.getManifestElement().getAndroidAttribute(16843291).orElseThrow(() -> new ManifestVersionException.VersionCodeMissingException())).getValueAsDecimalInteger();
    }

    public Optional<String> getSplitId() {
        return this.getManifestElement().getAttribute("split").map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString());
    }

    public Optional<Integer> getTitleRefId() {
        return this.getManifestElement().getOptionalChildElement(DISTRIBUTION_NAMESPACE, "module").flatMap(module -> module.getAttribute(DISTRIBUTION_NAMESPACE, "title")).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsRefId());
    }

    public ImmutableList<String> getUsesSplits() {
        return (ImmutableList)this.getManifestElement().getChildrenElements("uses-split").map(usesSplit -> (XmlProtoAttribute)usesSplit.getAndroidAttribute(0x1010003).orElseThrow(() -> new ValidationException("<uses-split> element is missing the 'android:name' attribute."))).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString()).collect(ImmutableList.toImmutableList());
    }

    public Optional<Boolean> isOnDemandModule(Version bundleToolVersion) {
        return this.getManifestElement().getOptionalChildElement(DISTRIBUTION_NAMESPACE, "module").flatMap(module -> {
            if (bundleToolVersion.isOlderThan(Version.of("0.3.4-dev"))) {
                return module.getAttributeIgnoringNamespace("onDemand");
            }
            return module.getAttribute(DISTRIBUTION_NAMESPACE, "onDemand");
        }).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean());
    }

    public Optional<Boolean> isInstantModule() {
        return this.getManifestElement().getOptionalChildElement(DISTRIBUTION_NAMESPACE, "module").flatMap(module -> module.getAttribute(DISTRIBUTION_NAMESPACE, "instant")).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean());
    }

    public ImmutableList<DeviceFeatureCondition> getDeviceFeatureConditions() {
        return this.getModuleConditions().getDeviceFeatureConditions();
    }

    public ModuleConditions getModuleConditions() {
        ImmutableList<XmlProtoElement> conditionElements = this.getModuleConditionElements();
        ModuleConditions.Builder moduleConditions = ModuleConditions.builder();
        block8: for (XmlProtoElement conditionElement : conditionElements) {
            if (!conditionElement.getNamespaceUri().equals(DISTRIBUTION_NAMESPACE)) {
                throw ValidationException.builder().withMessage("Invalid namespace found in the module condition element. Expected '%s'; found '%s'.", DISTRIBUTION_NAMESPACE, conditionElement.getNamespaceUri()).build();
            }
            switch (conditionElement.getName()) {
                case "device-feature": {
                    moduleConditions.addDeviceFeatureCondition(this.parseDeviceFeatureCondition(conditionElement));
                    continue block8;
                }
                case "min-sdk": {
                    moduleConditions.setMinSdkVersion(this.parseMinSdkVersionCondition(conditionElement));
                    continue block8;
                }
            }
            throw new ValidationException(String.format("Unrecognized module condition: '%s'", conditionElement.getName()));
        }
        return moduleConditions.build();
    }

    private ImmutableList<XmlProtoElement> getModuleConditionElements() {
        return this.getManifestElement().getOptionalChildElement(DISTRIBUTION_NAMESPACE, "module").flatMap(module -> module.getOptionalChildElement(DISTRIBUTION_NAMESPACE, "conditions")).map(conditions -> (ImmutableList)conditions.getChildrenElements().collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
    }

    private DeviceFeatureCondition parseDeviceFeatureCondition(XmlProtoElement conditionElement) {
        return DeviceFeatureCondition.create(((XmlProtoAttribute)conditionElement.getAttribute(DISTRIBUTION_NAMESPACE, NAME_ATTRIBUTE_NAME).orElseThrow(() -> new ValidationException("Missing required 'name' attribute in the 'device-feature' condition element."))).getValueAsString());
    }

    private int parseMinSdkVersionCondition(XmlProtoElement conditionElement) {
        return ((XmlProtoAttribute)conditionElement.getAttribute(DISTRIBUTION_NAMESPACE, VALUE_ATTRIBUTE_NAME).orElseThrow(() -> new ValidationException("Missing required 'value' attribute in the 'min-sdk' condition element."))).getValueAsDecimalInteger();
    }

    public Optional<Boolean> getExtractNativeLibsValue() {
        return this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME).flatMap(app -> app.getAndroidAttribute(16844010)).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean());
    }

    public ImmutableList<String> getFusedModuleNames() {
        return this.getMetadataValue(META_DATA_KEY_FUSED_MODULE_NAMES).map(rawValue -> ImmutableList.copyOf((Iterable)COMMA_SPLITTER.split((CharSequence)rawValue))).orElse(ImmutableList.of());
    }

    public Optional<String> getMetadataValue(String metadataName) {
        return this.getMetadataAttributeWithName(metadataName).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString());
    }

    public Optional<Integer> getMetadataValueAsInteger(String metadataName) {
        return this.getMetadataAttributeWithName(metadataName).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsDecimalInteger());
    }

    private Optional<XmlProtoAttribute> getMetadataAttributeWithName(String metadataName) {
        return this.getMetadataElement(metadataName).map(metadataElement -> (XmlProtoAttribute)metadataElement.getAndroidAttribute(16842788).orElseThrow(() -> ValidationException.builder().withMessage("Missing expected attribute 'android:value' for <meta-data> element '%s'.", metadataName).build()));
    }

    public Optional<Integer> getMetadataResourceId(String metadataName) {
        return this.getMetadataElement(metadataName).map(metadataElement -> (XmlProtoAttribute)metadataElement.getAndroidAttribute(16842789).orElseThrow(() -> ValidationException.builder().withMessage("Missing expected attribute 'android:resource' for <meta-data> element '%s'.", metadataName).build())).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsRefId());
    }

    private Optional<XmlProtoElement> getMetadataElement(String name) {
        ImmutableList metadataElements = (ImmutableList)this.getMetadataElements().filter(metadataElement -> metadataElement.getAndroidAttribute(0x1010003).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString()).orElse("").equals(name)).collect(ImmutableList.toImmutableList());
        switch (metadataElements.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(metadataElements.get(0));
            }
        }
        throw ValidationException.builder().withMessage("Found multiple <meta-data> elements for key '%s', expected at most one.", name).build();
    }

    private Stream<XmlProtoElement> getMetadataElements() {
        return this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME).map(applicationElement -> applicationElement.getChildrenElements(META_DATA_ELEMENT_NAME)).orElse(Stream.of(new XmlProtoElement[0]));
    }

    public ManifestEditor toEditor() {
        return new ManifestEditor(this.getManifestRoot());
    }
}

