/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.mergers.SameTargetingMerger;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ManifestMutator;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.splitters.AbiNativeLibrariesSplitter;
import com.android.tools.build.bundletool.splitters.LanguageAssetsSplitter;
import com.android.tools.build.bundletool.splitters.LanguageResourcesSplitter;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.splitters.NativeLibrariesCompressionSplitter;
import com.android.tools.build.bundletool.splitters.ScreenDensityResourcesSplitter;
import com.android.tools.build.bundletool.splitters.SplittingPipeline;
import com.android.tools.build.bundletool.splitters.VariantGrouper;
import com.android.tools.build.bundletool.version.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.protobuf.Int32Value;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;

public class ModuleSplitter {
    private final BundleModule module;
    private final ImmutableSet<OptimizationDimension> optimizationDimensions;
    private final SuffixManager suffixManager = new SuffixManager();
    private final Version bundleVersion;
    private boolean enableNativeLibraryCompressionSplitter = false;

    public ModuleSplitter(BundleModule module, ImmutableSet<OptimizationDimension> optimizationDimensions, Version bundleVersion) {
        this.optimizationDimensions = optimizationDimensions;
        this.module = module;
        this.bundleVersion = bundleVersion;
    }

    public void setEnableNativeLibraryCompressionSplitter(boolean value) {
        this.enableNativeLibraryCompressionSplitter = value;
    }

    public ImmutableList<ModuleSplit> splitModule() {
        return (ImmutableList)this.splitModuleInternal().stream().map(this::removeSplitName).collect(ImmutableList.toImmutableList());
    }

    public ImmutableList<ModuleSplit> splitInstantModule() {
        return (ImmutableList)this.splitModuleInternal().stream().map(ModuleSplitter::writeTargetSandboxVersion).map(moduleSplit -> moduleSplit.toBuilder().setSplitType(ModuleSplit.SplitType.INSTANT).build()).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<ModuleSplit> splitModuleInternal() {
        return (ImmutableList)this.runSplitters().stream().map(this::addLPlusTargeting).map(this::writeSplitIdInManifest).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<ModuleSplit> runSplitters() {
        if (ModuleSplitter.targetsOnlyPreL(this.module)) {
            throw CommandExecutionException.builder().withMessage("Cannot split module '%s' because it does not target devices on Android L or above.", this.module.getName()).build();
        }
        ImmutableList.Builder splits = ImmutableList.builder();
        SplittingPipeline resourcesPipeline = this.createResourcesSplittingPipeline();
        splits.addAll(resourcesPipeline.split(ModuleSplit.forResources(this.module)));
        SplittingPipeline nativePipeline = this.createNativeLibrariesSplittingPipeline();
        splits.addAll(nativePipeline.split(ModuleSplit.forNativeLibraries(this.module)));
        SplittingPipeline assetsPipeline = this.createAssetsSplittingPipeline();
        splits.addAll(assetsPipeline.split(ModuleSplit.forAssets(this.module)));
        splits.add((Object)ModuleSplit.forCode(this.module));
        splits.add((Object)ModuleSplit.forRoot(this.module));
        ImmutableMultimap<Targeting.VariantTargeting, ModuleSplit> variantModuleSplitMap = new VariantGrouper().groupByVariant((ImmutableCollection<ModuleSplit>)splits.build());
        ImmutableList.Builder mergedSplits = ImmutableList.builder();
        for (Collection moduleSplits : variantModuleSplitMap.asMap().values()) {
            mergedSplits.addAll(new SameTargetingMerger().merge((ImmutableCollection<ModuleSplit>)ModuleSplitter.applyMasterManifestMutators((ImmutableCollection<ModuleSplit>)ImmutableList.copyOf((Collection)moduleSplits))));
        }
        return mergedSplits.build();
    }

    public ModuleSplit writeSplitIdInManifest(ModuleSplit moduleSplit) {
        String resolvedSuffix = this.suffixManager.createSuffix(moduleSplit);
        return moduleSplit.writeSplitIdInManifest(resolvedSuffix);
    }

    public ModuleSplit removeSplitName(ModuleSplit moduleSplit) {
        return moduleSplit.removeSplitName();
    }

    public static ModuleSplit writeTargetSandboxVersion(ModuleSplit moduleSplit) {
        AndroidManifest apkManifest = moduleSplit.getAndroidManifest().toEditor().setTargetSandboxVersion(2).save();
        return moduleSplit.toBuilder().setAndroidManifest(apkManifest).build();
    }

    private SplittingPipeline createResourcesSplittingPipeline() {
        ImmutableList.Builder resourceSplitters = ImmutableList.builder();
        if (this.optimizationDimensions.contains((Object)OptimizationDimension.SCREEN_DENSITY)) {
            resourceSplitters.add((Object)new ScreenDensityResourcesSplitter(this.bundleVersion));
        }
        if (this.optimizationDimensions.contains((Object)OptimizationDimension.LANGUAGE)) {
            resourceSplitters.add((Object)new LanguageResourcesSplitter());
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)resourceSplitters.build());
    }

    public static ImmutableList<ModuleSplit> applyMasterManifestMutators(ImmutableCollection<ModuleSplit> moduleSplits) {
        Preconditions.checkState((moduleSplits.stream().map(ModuleSplit::getVariantTargeting).distinct().count() == 1L ? 1 : 0) != 0, (Object)"Expected same variant targeting across all splits.");
        ImmutableList manifestMutators = (ImmutableList)moduleSplits.stream().flatMap(moduleSplit -> moduleSplit.getMasterManifestMutators().stream()).collect(ImmutableList.toImmutableList());
        return (ImmutableList)moduleSplits.stream().map(moduleSplit -> {
            if (moduleSplit.isMasterSplit()) {
                moduleSplit = moduleSplit.toBuilder().setAndroidManifest(moduleSplit.getAndroidManifest().applyMutators((ImmutableList<ManifestMutator>)manifestMutators)).build();
            }
            return moduleSplit;
        }).collect(ImmutableList.toImmutableList());
    }

    private SplittingPipeline createNativeLibrariesSplittingPipeline() {
        ImmutableList.Builder nativeSplitters = ImmutableList.builder();
        if (this.enableNativeLibraryCompressionSplitter) {
            nativeSplitters.add((Object)new NativeLibrariesCompressionSplitter());
        }
        if (this.optimizationDimensions.contains((Object)OptimizationDimension.ABI)) {
            nativeSplitters.add((Object)new AbiNativeLibrariesSplitter());
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)nativeSplitters.build());
    }

    private SplittingPipeline createAssetsSplittingPipeline() {
        ImmutableList.Builder assetsSplitters = ImmutableList.builder();
        if (this.optimizationDimensions.contains((Object)OptimizationDimension.LANGUAGE)) {
            assetsSplitters.add((Object)LanguageAssetsSplitter.create());
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)assetsSplitters.build());
    }

    private static boolean targetsOnlyPreL(BundleModule module) {
        Optional<Integer> maxSdkVersion = module.getAndroidManifest().getMaxSdkVersion();
        return maxSdkVersion.isPresent() && maxSdkVersion.get() < 21;
    }

    private ModuleSplit addLPlusTargeting(ModuleSplit split) {
        if (split.getApkTargeting().hasSdkVersionTargeting()) {
            Preconditions.checkState((split.getApkTargeting().getSdkVersionTargeting().getValue(0).getMin().getValue() >= 21 ? 1 : 0) != 0, (Object)"Module Split should target SDK versions above L.");
            return split;
        }
        return split.toBuilder().setApkTargeting(split.getApkTargeting().toBuilder().setSdkVersionTargeting(Targeting.SdkVersionTargeting.newBuilder().addValue(Targeting.SdkVersion.newBuilder().setMin(Int32Value.newBuilder().setValue(21)))).build()).build();
    }

    private static class SuffixManager {
        @GuardedBy(value="this")
        private final Multimap<Targeting.VariantTargeting, String> usedSuffixes = HashMultimap.create();

        private SuffixManager() {
        }

        synchronized String createSuffix(ModuleSplit moduleSplit) {
            String currentProposal = moduleSplit.getSuffix();
            int serialNumber = 1;
            while (this.usedSuffixes.containsEntry((Object)moduleSplit.getVariantTargeting(), (Object)currentProposal)) {
                currentProposal = String.format("%s_%d", moduleSplit.getSuffix(), ++serialNumber);
            }
            this.usedSuffixes.put((Object)moduleSplit.getVariantTargeting(), (Object)currentProposal);
            return currentProposal;
        }
    }
}

