/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.R8;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.AndroidAppConsumers;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionUtils;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class DexRoundTrip {
    public static AndroidApp process(Collection<ProgramResource> dexResources) throws CompilationFailedException {
        InternalOptions options = new InternalOptions();
        options.useTreeShaking = false;
        options.skipMinification = true;
        options.ignoreMissingClasses = true;
        options.enableDesugaring = false;
        AndroidAppConsumers consumer = new AndroidAppConsumers(options);
        AndroidApp.Builder builder = AndroidApp.builder();
        ExceptionUtils.withR8CompilationHandler(options.reporter, () -> {
            for (ProgramResource resource : dexResources) {
                InputStream stream = resource.getByteStream();
                Throwable throwable = null;
                try {
                    builder.addDexProgramData(ByteStreams.toByteArray((InputStream)stream), resource.getOrigin());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            R8.runForTesting(builder.build(), options);
        });
        return consumer.build();
    }

    public static void main(String[] args) throws CompilationFailedException, IOException, ResourceException {
        ArrayList<ProgramResource> resources = new ArrayList<ProgramResource>(args.length);
        for (String arg : args) {
            Path file = Paths.get(arg, new String[0]);
            if (!FileUtils.isDexFile(file)) {
                throw new IllegalArgumentException("Only DEX files are supported as inputs. Invalid file: " + file);
            }
            resources.add(ProgramResource.fromFile(ProgramResource.Kind.DEX, file));
        }
        AndroidApp result = DexRoundTrip.process(resources);
        DexRoundTrip.process(result.computeAllProgramResources());
    }
}

