/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import shadow.bundletool.com.android.tools.r8.dex.DexFile;
import shadow.bundletool.com.android.tools.r8.dex.DexOutputBuffer;

public class EncodedValueUtils {
    public static long parseSigned(DexFile file, int numberOfBytes) {
        assert (numberOfBytes > 0);
        long result = 0L;
        int shift = 0;
        for (int i = 1; i < numberOfBytes; ++i) {
            result |= (long)(file.get() & 0xFF) << shift;
            shift += 8;
        }
        return result | (long)file.get() << shift;
    }

    public static int putSigned(DexOutputBuffer outputBuffer, long value, int expectedSize) {
        int bit_size = 65 - Long.numberOfLeadingZeros(value ^ value >> 63);
        int size = Math.max((bit_size + 8 - 1) / 8, 1);
        assert (size > 0 && size <= expectedSize);
        for (int i = 0; i < size; ++i) {
            outputBuffer.putByte((byte)value);
            value >>= 8;
        }
        return size;
    }

    public static byte[] encodeSigned(long value) {
        int bit_size = 65 - Long.numberOfLeadingZeros(value ^ value >> 63);
        int size = Math.max((bit_size + 8 - 1) / 8, 1);
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)value;
            value >>= 8;
        }
        return result;
    }

    public static long parseUnsigned(DexFile file, int numberOfBytes) {
        assert (numberOfBytes > 0);
        long result = 0L;
        int shift = 0;
        for (int i = 0; i < numberOfBytes; ++i) {
            result |= (long)(file.get() & 0xFF) << shift;
            shift += 8;
        }
        return result;
    }

    public static int putUnsigned(DexOutputBuffer outputBuffer, long value, int expectedSize) {
        int bit_size = 64 - Long.numberOfLeadingZeros(value);
        int size = Math.max((bit_size + 8 - 1) / 8, 1);
        assert (size > 0 && size <= expectedSize);
        for (int i = 0; i < size; ++i) {
            outputBuffer.putByte((byte)value);
            value >>= 8;
        }
        return size;
    }

    public static byte[] encodeUnsigned(long value) {
        int bit_size = 64 - Long.numberOfLeadingZeros(value);
        int size = Math.max((bit_size + 8 - 1) / 8, 1);
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)value;
            value >>= 8;
        }
        return result;
    }

    public static int putBitsFromRightZeroExtended(DexOutputBuffer outputBuffer, long value, int expectedSize) {
        int bit_size = 64 - Long.numberOfTrailingZeros(value);
        int size = (bit_size - 1) / 8 + 1;
        assert (size > 0 && size <= expectedSize);
        value >>= 64 - size * 8;
        for (int i = 0; i < size; ++i) {
            outputBuffer.putByte((byte)value);
            value >>= 8;
        }
        return size;
    }

    private static byte[] encodeBitsFromRightZeroExtended(long value) {
        int bit_size = 64 - Long.numberOfTrailingZeros(value);
        int size = (bit_size - 1) / 8 + 1;
        value >>= 64 - size * 8;
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)value;
            value >>= 8;
        }
        return result;
    }

    public static float parseFloat(DexFile file, int numberOfBytes) {
        long bits = EncodedValueUtils.parseUnsigned(file, numberOfBytes) << (4 - numberOfBytes) * 8;
        return Float.intBitsToFloat((int)bits);
    }

    public static int putFloat(DexOutputBuffer outputBuffer, float value) {
        long bits = (long)Float.floatToIntBits(value) << 32;
        return EncodedValueUtils.putBitsFromRightZeroExtended(outputBuffer, bits, 4);
    }

    public static byte[] encodeFloat(float value) {
        long tmp = (long)Float.floatToIntBits(value) << 32;
        byte[] result = EncodedValueUtils.encodeBitsFromRightZeroExtended(tmp);
        assert (result.length <= 4);
        return result;
    }

    public static double parseDouble(DexFile file, int numberOfBytes) {
        long bits = EncodedValueUtils.parseUnsigned(file, numberOfBytes) << (8 - numberOfBytes) * 8;
        return Double.longBitsToDouble(bits);
    }

    public static int putDouble(DexOutputBuffer outputBuffer, double value) {
        long bits = Double.doubleToLongBits(value);
        return EncodedValueUtils.putBitsFromRightZeroExtended(outputBuffer, bits, 8);
    }

    public static byte[] encodeDouble(double value) {
        long tmp = Double.doubleToLongBits(value);
        byte[] result = EncodedValueUtils.encodeBitsFromRightZeroExtended(tmp);
        assert (result.length <= 8);
        return result;
    }
}

