/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.targeting;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.targeting.TargetingDimension;
import com.android.tools.build.bundletool.utils.TargetingProtoUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;

public final class TargetingUtils {
    public static ImmutableList<TargetingDimension> getTargetingDimensions(Targeting.AssetsDirectoryTargeting targeting) {
        ImmutableList.Builder dimensions = new ImmutableList.Builder();
        if (targeting.hasAbi()) {
            dimensions.add((Object)TargetingDimension.ABI);
        }
        if (targeting.hasGraphicsApi()) {
            dimensions.add((Object)TargetingDimension.GRAPHICS_API);
        }
        if (targeting.hasTextureCompressionFormat()) {
            dimensions.add((Object)TargetingDimension.TEXTURE_COMPRESSION_FORMAT);
        }
        if (targeting.hasLanguage()) {
            dimensions.add((Object)TargetingDimension.LANGUAGE);
        }
        return dimensions.build();
    }

    private static boolean checkVariantMatchWithModuleSplit(Targeting.VariantTargeting variantTargeting, ModuleSplit moduleSplit) {
        boolean encloses;
        Targeting.SdkVersionTargeting variantSdkTargeting = variantTargeting.getSdkVersionTargeting();
        int variantTargetingMinSdk = TargetingUtils.getMinSdk(variantSdkTargeting);
        int variantTargetingMaxSdk = TargetingUtils.getMaxSdk(variantSdkTargeting);
        Targeting.SdkVersionTargeting moduleSplitSdkTargeting = moduleSplit.getVariantTargeting().getSdkVersionTargeting();
        int moduleSplitMinSdk = TargetingUtils.getMinSdk(moduleSplitSdkTargeting);
        int moduleSplitMaxSdk = TargetingUtils.getMaxSdk(moduleSplitSdkTargeting);
        boolean bl = encloses = variantTargetingMinSdk >= moduleSplitMinSdk && variantTargetingMaxSdk <= moduleSplitMaxSdk;
        if (!encloses) {
            Preconditions.checkState((variantTargetingMaxSdk <= moduleSplitMinSdk || moduleSplitMaxSdk <= variantTargetingMinSdk ? 1 : 0) != 0, (String)"Partial overlap between the sdk ranges of variant [ %s, %s )  and module split [ %s, %s ).", (Object)variantTargetingMinSdk, (Object)variantTargetingMaxSdk, (Object)moduleSplitMinSdk, (Object)moduleSplitMaxSdk);
            return false;
        }
        return true;
    }

    public static ImmutableMultimap<Targeting.VariantTargeting, ModuleSplit> matchModuleSplitWithVariants(ImmutableCollection<Targeting.VariantTargeting> variants, ImmutableCollection<ModuleSplit> moduleSplits) {
        ImmutableMultimap.Builder mapping = ImmutableMultimap.builder();
        for (Targeting.VariantTargeting variant : variants) {
            for (ModuleSplit moduleSplit : moduleSplits) {
                if (!TargetingUtils.checkVariantMatchWithModuleSplit(variant, moduleSplit)) continue;
                mapping.put((Object)variant, (Object)moduleSplit);
            }
        }
        return mapping.build();
    }

    public static ImmutableSet<Targeting.VariantTargeting> generateAllVariantTargetings(ImmutableSet<Targeting.VariantTargeting> variantTargetings) {
        if (variantTargetings.size() <= 1) {
            return variantTargetings;
        }
        ImmutableList<Targeting.SdkVersionTargeting> sdkVersionTargetings = TargetingUtils.generateAllSdkTargetings((ImmutableList<Targeting.SdkVersionTargeting>)((ImmutableList)variantTargetings.stream().map(variantTargeting -> variantTargeting.getSdkVersionTargeting()).collect(ImmutableList.toImmutableList())));
        return (ImmutableSet)sdkVersionTargetings.stream().map(sdkVersionTargeting -> Targeting.VariantTargeting.newBuilder().setSdkVersionTargeting((Targeting.SdkVersionTargeting)sdkVersionTargeting).build()).collect(ImmutableSet.toImmutableSet());
    }

    private static ImmutableList<Targeting.SdkVersionTargeting> generateAllSdkTargetings(ImmutableList<Targeting.SdkVersionTargeting> sdkVersionTargetings) {
        sdkVersionTargetings.forEach(sdkVersionTargeting -> Preconditions.checkState((sdkVersionTargeting.getValueList().size() == 1 ? 1 : 0) != 0));
        ImmutableList minSdkValues = (ImmutableList)sdkVersionTargetings.stream().map(sdkVersionTargeting -> sdkVersionTargeting.getValue(0).getMin().getValue()).distinct().sorted().collect(ImmutableList.toImmutableList());
        ImmutableSet sdkVersions = (ImmutableSet)minSdkValues.stream().map(TargetingProtoUtils::sdkVersionFrom).collect(ImmutableSet.toImmutableSet());
        return (ImmutableList)sdkVersions.stream().map(sdkVersion -> TargetingProtoUtils.sdkVersionTargeting(sdkVersion, (ImmutableSet<Targeting.SdkVersion>)Sets.difference((Set)sdkVersions, (Set)ImmutableSet.of((Object)sdkVersion)).immutableCopy())).collect(ImmutableList.toImmutableList());
    }

    private static int getMinSdk(Targeting.SdkVersionTargeting sdkVersionTargeting) {
        if (sdkVersionTargeting.getValueList().isEmpty()) {
            return 1;
        }
        return sdkVersionTargeting.getValue(0).getMin().getValue();
    }

    private static int getMaxSdk(Targeting.SdkVersionTargeting sdkVersionTargeting) {
        int minSdk = TargetingUtils.getMinSdk(sdkVersionTargeting);
        int alternativeMinSdk = sdkVersionTargeting.getAlternativesList().stream().mapToInt(alternativeSdk -> alternativeSdk.getMin().getValue()).filter(sdkValue -> minSdk < sdkValue).min().orElse(Integer.MAX_VALUE);
        return alternativeMinSdk;
    }
}

