/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils;

import com.android.bundle.Commands;
import com.google.common.collect.ImmutableList;

public final class ResultUtils {
    public static ImmutableList<Commands.Variant> splitApkVariants(Commands.BuildApksResult result) {
        return (ImmutableList)result.getVariantList().stream().filter(ResultUtils::isSplitApkVariant).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Commands.Variant> instantApkVariants(Commands.BuildApksResult result) {
        return (ImmutableList)result.getVariantList().stream().filter(ResultUtils::isInstantApkVariant).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Commands.Variant> standaloneApkVariants(Commands.BuildApksResult result) {
        return (ImmutableList)result.getVariantList().stream().filter(ResultUtils::isStandaloneApkVariant).collect(ImmutableList.toImmutableList());
    }

    public static boolean isSplitApkVariant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap(apkSet -> apkSet.getApkDescriptionList().stream()).allMatch(Commands.ApkDescription::hasSplitApkMetadata);
    }

    public static boolean isStandaloneApkVariant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap(apkSet -> apkSet.getApkDescriptionList().stream()).allMatch(Commands.ApkDescription::hasStandaloneApkMetadata);
    }

    public static boolean isInstantApkVariant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap(apkSet -> apkSet.getApkDescriptionList().stream()).allMatch(Commands.ApkDescription::hasInstantApkMetadata);
    }

    private ResultUtils() {
    }
}

