/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class DebugLocalsChange
extends Instruction {
    private final Int2ReferenceMap<DebugLocalInfo> ending;
    private final Int2ReferenceMap<DebugLocalInfo> starting;

    public DebugLocalsChange(Int2ReferenceMap<DebugLocalInfo> ending, Int2ReferenceMap<DebugLocalInfo> starting) {
        super(null);
        assert (!ending.isEmpty() || !starting.isEmpty());
        this.ending = ending;
        this.starting = starting;
        super.setPosition(Position.none());
    }

    @Override
    public void setPosition(Position position) {
        throw new Unreachable();
    }

    public Int2ReferenceMap<DebugLocalInfo> getEnding() {
        return this.ending;
    }

    public Int2ReferenceMap<DebugLocalInfo> getStarting() {
        return this.starting;
    }

    @Override
    public boolean isDebugLocalsChange() {
        return true;
    }

    @Override
    public DebugLocalsChange asDebugLocalsChange() {
        return this;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.addNop(this);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        assert (other.isDebugLocalsChange());
        DebugLocalsChange o = (DebugLocalsChange)other;
        return DebugLocalInfo.localsInfoMapsEqual(this.ending, o.ending) && DebugLocalInfo.localsInfoMapsEqual(this.starting, o.starting);
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        assert (other.isDebugLocalsChange());
        return 0;
    }

    @Override
    public int maxInValueRegister() {
        throw new Unreachable();
    }

    @Override
    public int maxOutValueRegister() {
        throw new Unreachable();
    }

    @Override
    public boolean canBeDeadCode(IRCode code, InternalOptions options) {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("ending: ");
        StringUtils.append(builder, this.ending.int2ReferenceEntrySet());
        builder.append(", starting: ");
        StringUtils.append(builder, this.starting.int2ReferenceEntrySet());
        return builder.toString();
    }

    @Override
    public Inliner.Constraint inliningConstraint(Enqueuer.AppInfoWithLiveness info, DexType invocationContext) {
        return Inliner.Constraint.ALWAYS;
    }

    public boolean apply(Int2ReferenceMap<DebugLocalInfo> locals) {
        boolean changed = false;
        for (Int2ReferenceMap.Entry end : this.getEnding().int2ReferenceEntrySet()) {
            assert (locals.get(end.getIntKey()) == end.getValue());
            if (locals.remove(end.getIntKey()) == null) continue;
            changed = true;
        }
        for (Int2ReferenceMap.Entry start : this.getStarting().int2ReferenceEntrySet()) {
            assert (!locals.containsKey(start.getIntKey()));
            DebugLocalInfo old = (DebugLocalInfo)locals.put(start.getIntKey(), (Object)((DebugLocalInfo)start.getValue()));
            changed |= old == null || old != start.getValue();
        }
        return changed;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw new Unreachable();
    }

    @Override
    public void buildCf(CfBuilder builder) {
        throw new Unreachable();
    }
}

