/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

public abstract class ProguardTypeMatcher {
    private static final String MATCH_ALL_PATTERN = "***";
    private static final String MATCH_ANY_ARG_SEQUENCE_PATTERN = "...";
    private static final String LEGACY_MATCH_CLASS_PATTERN = "*";
    private static final String MATCH_CLASS_PATTERN = "**";
    private static final String MATCH_BASIC_PATTERN = "%";

    private ProguardTypeMatcher() {
    }

    public abstract boolean matches(DexType var1);

    public abstract String toString();

    public boolean isTripleDotPattern() {
        return false;
    }

    public static ProguardTypeMatcher create(String pattern, ClassOrType kind, DexItemFactory dexItemFactory) {
        if (pattern == null) {
            return null;
        }
        switch (pattern) {
            case "***": {
                return MatchAllTypes.MATCH_ALL_TYPES;
            }
            case "...": {
                return MatchAnyArgSequence.MATCH_ANY_ARG_SEQUENCE;
            }
            case "**": {
                return MatchClassTypes.MATCH_CLASS_TYPES;
            }
            case "*": {
                return MatchClassTypes.LEGACY_MATCH_CLASS_TYPES;
            }
            case "%": {
                return MatchBasicTypes.MATCH_BASIC_TYPES;
            }
        }
        if (!(pattern.contains(LEGACY_MATCH_CLASS_PATTERN) || pattern.contains(MATCH_BASIC_PATTERN) || pattern.contains("?"))) {
            return new MatchSpecificType(dexItemFactory.createType(DescriptorUtils.javaTypeToDescriptor(pattern)));
        }
        return new MatchTypePattern(pattern, kind);
    }

    public static ProguardTypeMatcher create(DexType type) {
        return new MatchSpecificType(type);
    }

    public static ProguardTypeMatcher defaultAllMatcher() {
        return MatchAllTypes.MATCH_ALL_TYPES;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public DexType getSpecificType() {
        return null;
    }

    private static class MatchTypePattern
    extends ProguardTypeMatcher {
        private final String pattern;
        private final ClassOrType kind;

        private MatchTypePattern(String pattern, ClassOrType kind) {
            this.pattern = pattern;
            this.kind = kind;
        }

        @Override
        public boolean matches(DexType type) {
            String typeName = type.toSourceString();
            return MatchTypePattern.matchClassOrTypeNameImpl(this.pattern, 0, typeName, 0, this.kind);
        }

        private static boolean matchClassOrTypeNameImpl(String pattern, int patternIndex, String className, int nameIndex, ClassOrType kind) {
            block4: for (int i = patternIndex; i < pattern.length(); ++i) {
                char patternChar = pattern.charAt(i);
                switch (patternChar) {
                    case '*': {
                        boolean includeSeparators = pattern.length() > i + 1 && pattern.charAt(i + 1) == '*';
                        int nextPatternIndex = i + (includeSeparators ? 2 : 1);
                        if (nextPatternIndex == pattern.length()) {
                            if (includeSeparators) {
                                return kind == ClassOrType.CLASS || !MatchTypePattern.isArrayType(className);
                            }
                            boolean hasSeparators = MatchTypePattern.containsSeparatorsStartingAt(className, nameIndex);
                            return !hasSeparators && (kind == ClassOrType.CLASS || !MatchTypePattern.isArrayType(className));
                        }
                        for (int nextNameIndex = nameIndex; nextNameIndex < className.length(); ++nextNameIndex) {
                            if (!includeSeparators && className.charAt(nextNameIndex) == '.') {
                                return MatchTypePattern.matchClassOrTypeNameImpl(pattern, nextPatternIndex, className, nextNameIndex, kind);
                            }
                            if (kind == ClassOrType.TYPE && className.charAt(nextNameIndex) == '[') {
                                return MatchTypePattern.matchClassOrTypeNameImpl(pattern, nextPatternIndex, className, nextNameIndex, kind);
                            }
                            if (!MatchTypePattern.matchClassOrTypeNameImpl(pattern, nextPatternIndex, className, nextNameIndex, kind)) continue;
                            return true;
                        }
                        return MatchTypePattern.matchClassOrTypeNameImpl(pattern, nextPatternIndex, className, className.length(), kind);
                    }
                    case '?': {
                        if (nameIndex != className.length() && className.charAt(nameIndex++) != '.') continue block4;
                        return false;
                    }
                    default: {
                        if (nameIndex != className.length() && patternChar == className.charAt(nameIndex++)) continue block4;
                        return false;
                    }
                }
            }
            return nameIndex == className.length();
        }

        private static boolean containsSeparatorsStartingAt(String className, int nameIndex) {
            return className.indexOf(46, nameIndex) != -1;
        }

        private static boolean isArrayType(String type) {
            int length = type.length();
            if (length < 2) {
                return false;
            }
            return type.charAt(length - 1) == ']' && type.charAt(length - 2) == '[';
        }

        @Override
        public String toString() {
            return this.pattern;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof MatchTypePattern) {
                MatchTypePattern that = (MatchTypePattern)o;
                return this.kind.equals((Object)that.kind) && this.pattern.equals(that.pattern);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.pattern.hashCode() * 7 + this.kind.hashCode();
        }
    }

    public static class MatchSpecificType
    extends ProguardTypeMatcher {
        public final DexType type;

        private MatchSpecificType(DexType type) {
            this.type = type;
        }

        @Override
        public boolean matches(DexType type) {
            return this.type == type;
        }

        @Override
        public String toString() {
            return this.type.toSourceString();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof MatchSpecificType) {
                return this.type.equals(((MatchSpecificType)o).type);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.type.hashCode();
        }

        @Override
        public DexType getSpecificType() {
            return this.type;
        }
    }

    private static class MatchBasicTypes
    extends ProguardTypeMatcher {
        private static final ProguardTypeMatcher MATCH_BASIC_TYPES = new MatchBasicTypes();

        private MatchBasicTypes() {
        }

        @Override
        public boolean matches(DexType type) {
            return type.isPrimitiveType();
        }

        @Override
        public String toString() {
            return ProguardTypeMatcher.MATCH_BASIC_PATTERN;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof MatchBasicTypes;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static class MatchClassTypes
    extends ProguardTypeMatcher {
        private static final ProguardTypeMatcher MATCH_CLASS_TYPES = new MatchClassTypes("**");
        private static final ProguardTypeMatcher LEGACY_MATCH_CLASS_TYPES = new MatchClassTypes("*");
        private final String pattern;

        private MatchClassTypes(String pattern) {
            assert (pattern.equals(ProguardTypeMatcher.LEGACY_MATCH_CLASS_PATTERN) || pattern.equals(ProguardTypeMatcher.MATCH_CLASS_PATTERN));
            this.pattern = pattern;
        }

        @Override
        public boolean matches(DexType type) {
            return type.isClassType();
        }

        @Override
        public String toString() {
            return this.pattern;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof MatchClassTypes && this.pattern.equals(((MatchClassTypes)o).pattern);
        }

        @Override
        public int hashCode() {
            return this.pattern.hashCode();
        }
    }

    private static class MatchAnyArgSequence
    extends ProguardTypeMatcher {
        private static final ProguardTypeMatcher MATCH_ANY_ARG_SEQUENCE = new MatchAnyArgSequence();

        private MatchAnyArgSequence() {
        }

        @Override
        public boolean matches(DexType type) {
            throw new IllegalStateException();
        }

        @Override
        public String toString() {
            return ProguardTypeMatcher.MATCH_ANY_ARG_SEQUENCE_PATTERN;
        }

        @Override
        public boolean isTripleDotPattern() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof MatchAnyArgSequence;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static class MatchAllTypes
    extends ProguardTypeMatcher {
        private static final ProguardTypeMatcher MATCH_ALL_TYPES = new MatchAllTypes();

        private MatchAllTypes() {
        }

        @Override
        public boolean matches(DexType type) {
            return true;
        }

        @Override
        public String toString() {
            return ProguardTypeMatcher.MATCH_ALL_PATTERN;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof MatchAllTypes;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    static enum ClassOrType {
        CLASS,
        TYPE;

    }
}

