
package com.android.tools.build.bundletool.device;

import java.time.Duration;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_Device_InstallOptions extends Device.InstallOptions {

  private final boolean allowDowngrade;
  private final boolean allowReinstall;
  private final Duration timeout;

  private AutoValue_Device_InstallOptions(
      boolean allowDowngrade,
      boolean allowReinstall,
      Duration timeout) {
    this.allowDowngrade = allowDowngrade;
    this.allowReinstall = allowReinstall;
    this.timeout = timeout;
  }

  @Override
  public boolean getAllowDowngrade() {
    return allowDowngrade;
  }

  @Override
  public boolean getAllowReinstall() {
    return allowReinstall;
  }

  @Override
  public Duration getTimeout() {
    return timeout;
  }

  @Override
  public String toString() {
    return "InstallOptions{"
        + "allowDowngrade=" + allowDowngrade + ", "
        + "allowReinstall=" + allowReinstall + ", "
        + "timeout=" + timeout
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Device.InstallOptions) {
      Device.InstallOptions that = (Device.InstallOptions) o;
      return (this.allowDowngrade == that.getAllowDowngrade())
           && (this.allowReinstall == that.getAllowReinstall())
           && (this.timeout.equals(that.getTimeout()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.allowDowngrade ? 1231 : 1237;
    h *= 1000003;
    h ^= this.allowReinstall ? 1231 : 1237;
    h *= 1000003;
    h ^= this.timeout.hashCode();
    return h;
  }

  static final class Builder extends Device.InstallOptions.Builder {
    private Boolean allowDowngrade;
    private Boolean allowReinstall;
    private Duration timeout;
    Builder() {
    }
    @Override
    public Device.InstallOptions.Builder setAllowDowngrade(boolean allowDowngrade) {
      this.allowDowngrade = allowDowngrade;
      return this;
    }
    @Override
    public Device.InstallOptions.Builder setAllowReinstall(boolean allowReinstall) {
      this.allowReinstall = allowReinstall;
      return this;
    }
    @Override
    public Device.InstallOptions.Builder setTimeout(Duration timeout) {
      if (timeout == null) {
        throw new NullPointerException("Null timeout");
      }
      this.timeout = timeout;
      return this;
    }
    @Override
    public Device.InstallOptions build() {
      String missing = "";
      if (this.allowDowngrade == null) {
        missing += " allowDowngrade";
      }
      if (this.allowReinstall == null) {
        missing += " allowReinstall";
      }
      if (this.timeout == null) {
        missing += " timeout";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Device_InstallOptions(
          this.allowDowngrade,
          this.allowReinstall,
          this.timeout);
    }
  }

}
