/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.targeting.TargetingGenerator;
import com.android.tools.build.bundletool.splitters.AbiPlaceholderInjector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.Collection;
import javax.inject.Inject;

public class StandaloneApkSerializer {
    private final ApkSerializerHelper apkSerializerHelper;

    @Inject
    public StandaloneApkSerializer(ApkSerializerHelper apkSerializerHelper) {
        this.apkSerializerHelper = apkSerializerHelper;
    }

    public Commands.ApkDescription writeToDisk(ModuleSplit standaloneSplit, Path outputDirectory, ZipPath apkPath) {
        return this.writeToDiskInternal(standaloneSplit, outputDirectory, apkPath);
    }

    public Commands.ApkDescription writeToDiskAsUniversal(ModuleSplit standaloneSplit, Path outputDirectory) {
        return this.writeToDiskInternal(standaloneSplit, outputDirectory, ZipPath.create("universal.apk"));
    }

    public Commands.ApkDescription writeSystemApkToDisk(ModuleSplit systemSplit, Path outputDirectory, ZipPath apkPath) {
        return this.writeSystemApkToDiskInternal(systemSplit, outputDirectory, Commands.SystemApkMetadata.SystemApkType.SYSTEM, apkPath);
    }

    public ImmutableList<Commands.ApkDescription> writeCompressedSystemApksToDisk(ModuleSplit systemSplit, Path outputDirectory, ZipPath apkPath) {
        Commands.ApkDescription stubApkDescription = this.writeSystemApkToDiskInternal(StandaloneApkSerializer.splitWithOnlyManifest(systemSplit), outputDirectory, Commands.SystemApkMetadata.SystemApkType.SYSTEM_STUB, apkPath);
        ZipPath compressedApkPath = ZipPath.create(StandaloneApkSerializer.getCompressedApkPathFromStubApkPath(stubApkDescription.getPath()));
        this.apkSerializerHelper.writeCompressedApkToZipFile(systemSplit, outputDirectory.resolve(compressedApkPath.toString()));
        return ImmutableList.of((Object)stubApkDescription, (Object)StandaloneApkSerializer.createSystemApkDescription(systemSplit, compressedApkPath, Commands.SystemApkMetadata.SystemApkType.SYSTEM_COMPRESSED));
    }

    @VisibleForTesting
    Commands.ApkDescription writeToDiskInternal(ModuleSplit standaloneSplit, Path outputDirectory, ZipPath apkPath) {
        this.apkSerializerHelper.writeToZipFile(standaloneSplit, outputDirectory.resolve(apkPath.toString()));
        Commands.ApkDescription.Builder apkDescription = Commands.ApkDescription.newBuilder().setPath(apkPath.toString()).setTargeting(standaloneSplit.getApkTargeting());
        if (standaloneSplit.isApex()) {
            apkDescription.setApexApkMetadata(Commands.ApexApkMetadata.newBuilder().addAllApexEmbeddedApkConfig((Iterable<? extends Config.ApexEmbeddedApkConfig>)standaloneSplit.getApexEmbeddedApkConfigs()).build());
        } else {
            apkDescription.setStandaloneApkMetadata(Commands.StandaloneApkMetadata.newBuilder().addAllFusedModuleName((Iterable<String>)standaloneSplit.getAndroidManifest().getFusedModuleNames()));
        }
        return apkDescription.build();
    }

    private Commands.ApkDescription writeSystemApkToDiskInternal(ModuleSplit systemSplit, Path outputDirectory, Commands.SystemApkMetadata.SystemApkType apkType, ZipPath apkPath) {
        this.apkSerializerHelper.writeToZipFile(systemSplit, outputDirectory.resolve(apkPath.toString()));
        return StandaloneApkSerializer.createSystemApkDescription(systemSplit, apkPath, apkType);
    }

    private static String getCompressedApkPathFromStubApkPath(String stubApkPath) {
        Preconditions.checkArgument((boolean)stubApkPath.endsWith(".apk"));
        return stubApkPath + ".gz";
    }

    private static Commands.ApkDescription createSystemApkDescription(ModuleSplit systemSplit, ZipPath apkPath, Commands.SystemApkMetadata.SystemApkType apkType) {
        Commands.ApkDescription.Builder apkDescription = Commands.ApkDescription.newBuilder().setPath(apkPath.toString()).setTargeting(systemSplit.getApkTargeting());
        if (systemSplit.isBaseModuleSplit() && systemSplit.isMasterSplit()) {
            apkDescription.setSystemApkMetadata(Commands.SystemApkMetadata.newBuilder().addAllFusedModuleName((Iterable<String>)systemSplit.getAndroidManifest().getFusedModuleNames()).setSystemApkType(apkType));
        } else {
            apkDescription.setSplitApkMetadata(Commands.SplitApkMetadata.newBuilder().setSplitId(systemSplit.getAndroidManifest().getSplitId().get()).setIsMasterSplit(systemSplit.isMasterSplit()));
        }
        return apkDescription.build();
    }

    private static ModuleSplit splitWithOnlyManifest(ModuleSplit split) {
        ModuleSplit stubSplit = ModuleSplit.builder().setModuleName(split.getModuleName()).setSplitType(split.getSplitType()).setVariantTargeting(split.getVariantTargeting()).setApkTargeting(split.getApkTargeting()).setAndroidManifest(split.getAndroidManifest()).setMasterSplit(split.isMasterSplit()).build();
        ImmutableSet<Targeting.Abi> abis = StandaloneApkSerializer.getTargetedAbis(split);
        if (abis.isEmpty()) {
            return stubSplit;
        }
        AbiPlaceholderInjector abiPlaceholderInjector = new AbiPlaceholderInjector(abis);
        ModuleSplit result = abiPlaceholderInjector.addPlaceholderNativeEntries(stubSplit);
        return result;
    }

    private static ImmutableSet<Targeting.Abi> getTargetedAbis(ModuleSplit split) {
        Collection nativeLibDirs = (Collection)split.getEntries().stream().filter(entry -> {
            String path = entry.getPath().toString();
            return path.startsWith("lib/") && path.endsWith(".so");
        }).map(entry -> entry.getPath().getParent().toString()).collect(ImmutableSet.toImmutableSet());
        if (nativeLibDirs.isEmpty()) {
            return ImmutableSet.of();
        }
        Files.NativeLibraries nativeLibraries = new TargetingGenerator().generateTargetingForNativeLibraries(nativeLibDirs);
        return (ImmutableSet)nativeLibraries.getDirectoryList().stream().map(Files.TargetedNativeDirectory::getTargeting).map(Targeting.NativeDirectoryTargeting::getAbi).collect(ImmutableSet.toImmutableSet());
    }
}

