/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import shadow.bundletool.com.android.utils.StringHelper;

public class StringHelperPOSIX
extends StringHelper {
    public static List<String> splitCommandLine(String commandLine) {
        ArrayList commands = Lists.newArrayList();
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        int commandStart = 0;
        for (int i4 = 0; i4 < commandLine.length(); ++i4) {
            char c4 = commandLine.charAt(i4);
            if (escaping) {
                escaping = false;
                continue;
            }
            if (!(c4 != '\\' || quoting && quote != '\"')) {
                escaping = true;
                continue;
            }
            if (!(quoting || c4 != '\"' && c4 != '\'')) {
                quoting = true;
                quote = c4;
                continue;
            }
            if (quoting && c4 == quote) {
                quoting = false;
                quote = '\u0000';
                continue;
            }
            if (quoting) continue;
            int matched = 0;
            if (commandLine.length() > i4 + 1 && commandLine.charAt(i4) == '&' && commandLine.charAt(i4 + 1) == '&') {
                matched = 2;
            } else if (commandLine.charAt(i4) == ';') {
                matched = 1;
            }
            if (matched <= 0) continue;
            commands.add(commandLine.substring(commandStart, i4));
            commandStart = i4 += matched;
        }
        if (commandStart < commandLine.length()) {
            commands.add(commandLine.substring(commandStart));
        }
        return commands;
    }

    public static List<String> tokenizeCommandLineToEscaped(String commandLine) {
        return StringHelperPOSIX.tokenizeCommandLine(commandLine, true);
    }

    public static List<String> tokenizeCommandLineToRaw(String commandLine) {
        return StringHelperPOSIX.tokenizeCommandLine(commandLine, false);
    }

    private static List<String> tokenizeCommandLine(String commandLine, boolean returnEscaped) {
        ArrayList tokens = Lists.newArrayList();
        StringBuilder token = new StringBuilder();
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        boolean skipping = true;
        for (int i4 = 0; i4 < commandLine.length(); ++i4) {
            char c4 = commandLine.charAt(i4);
            if (skipping) {
                if (Character.isWhitespace(c4)) continue;
                skipping = false;
            }
            if (!(!quoting && Character.isWhitespace(c4) || returnEscaped)) {
                token.append(c4);
            }
            if (escaping) {
                escaping = false;
                if (c4 == '\n' || !returnEscaped) continue;
                token.append(c4);
                continue;
            }
            if (!(c4 != '\\' || quoting && quote != '\"')) {
                escaping = true;
                continue;
            }
            if (!(quoting || c4 != '\"' && c4 != '\'')) {
                quoting = true;
                quote = c4;
                continue;
            }
            if (quoting && c4 == quote) {
                quoting = false;
                quote = '\u0000';
                continue;
            }
            if (!quoting && Character.isWhitespace(c4)) {
                skipping = true;
                if (token.length() > 0) {
                    tokens.add(token.toString());
                }
                token.setLength(0);
                continue;
            }
            if (!returnEscaped) continue;
            token.append(c4);
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens;
    }
}

