/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ClassesDexEntriesMutator {
    private static final Pattern CLASSES_DEX_REGEX_PATTERN = Pattern.compile("dex/classes(\\d*)\\.dex");
    private static final Predicate<ModuleEntry> IS_DEX_FILE = entry -> entry.getPath().toString().matches(CLASSES_DEX_REGEX_PATTERN.pattern());
    public static final Function<ImmutableList<ModuleEntry>, ImmutableList<ModuleEntry>> CLASSES_DEX_NAME_SANITIZER = dexEntries -> (ImmutableList)dexEntries.stream().map(ClassesDexEntriesMutator::sanitizeDexEntryName).collect(ImmutableList.toImmutableList());
    public static final Function<ImmutableList<ModuleEntry>, ImmutableList<ModuleEntry>> R_PACKAGE_DEX_ENTRY_REMOVER = dexEntries -> (ImmutableList)dexEntries.stream().sorted(Comparator.comparing(dexEntry -> ClassesDexEntriesMutator.getClassesIndexForDexPath(dexEntry.getPath()))).limit(Math.max(dexEntries.size() - 1, 0)).collect(ImmutableList.toImmutableList());

    @CheckReturnValue
    public BundleModule applyMutation(BundleModule module, Function<ImmutableList<ModuleEntry>, ImmutableList<ModuleEntry>> mutator) {
        if (!ClassesDexEntriesMutator.shouldApplyMutation(module, mutator)) {
            return module;
        }
        Map partitionedEntries = module.getEntries().stream().collect(Collectors.partitioningBy(IS_DEX_FILE, ImmutableList.toImmutableList()));
        ImmutableList dexEntries = (ImmutableList)partitionedEntries.get(true);
        ImmutableList nonDexEntries = (ImmutableList)partitionedEntries.get(false);
        ImmutableList newEntries = ImmutableList.builder().addAll((Iterable)nonDexEntries).addAll((Iterable)mutator.apply((ImmutableList<ModuleEntry>)dexEntries)).build();
        return module.toBuilder().setEntryMap((ImmutableMap<ZipPath, ModuleEntry>)((ImmutableMap)newEntries.stream().collect(ImmutableMap.toImmutableMap(ModuleEntry::getPath, Function.identity())))).build();
    }

    private static ModuleEntry sanitizeDexEntryName(ModuleEntry dexEntry) {
        ZipPath sanitizedEntryPath = ClassesDexEntriesMutator.incrementClassesDexNumber(dexEntry.getPath());
        return dexEntry.toBuilder().setPath(sanitizedEntryPath).build();
    }

    private static ZipPath incrementClassesDexNumber(ZipPath entryPath) {
        int num = ClassesDexEntriesMutator.getClassesIndexForDexPath(entryPath);
        if (num == 0) {
            return entryPath;
        }
        return ZipPath.create("dex/classes" + (num + 1) + ".dex");
    }

    private static int getClassesIndexForDexPath(ZipPath entryPath) {
        String fileName = entryPath.toString();
        Matcher matcher = CLASSES_DEX_REGEX_PATTERN.matcher(fileName);
        Preconditions.checkState((boolean)matcher.matches());
        String num = matcher.group(1);
        if (num.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(num);
    }

    private static boolean shouldApplyMutation(BundleModule module, Function<ImmutableList<ModuleEntry>, ImmutableList<ModuleEntry>> mutator) {
        if (mutator.equals(CLASSES_DEX_NAME_SANITIZER)) {
            return module.getEntry(ZipPath.create("dex/classes1.dex")).isPresent();
        }
        return true;
    }
}

